// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.StsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AssumeRoleWithWebIdentityOperationDeserializer: HttpDeserialize<AssumeRoleWithWebIdentityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AssumeRoleWithWebIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleWithWebIdentityError(context, call)
        }
        val builder = AssumeRoleWithWebIdentityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssumeRoleWithWebIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAssumeRoleWithWebIdentityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw StsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "IDPRejectedClaim" -> IdpRejectedClaimExceptionDeserializer().deserialize(context, wrappedCall)
        "MalformedPolicyDocument" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidIdentityToken" -> InvalidIdentityTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "RegionDisabledException" -> RegionDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "PackedPolicyTooLarge" -> PackedPolicyTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "IDPCommunicationError" -> IdpCommunicationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> StsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleWithWebIdentityOperationBody(builder: AssumeRoleWithWebIdentityResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AssumeRoleWithWebIdentity")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AssumedRoleUser com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$AssumedRoleUser
            "AssumedRoleUser" -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(curr)
            // Audience com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Audience
            "Audience" -> builder.audience = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#Audience`)" }
            // Credentials com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Credentials
            "Credentials" -> builder.credentials = deserializeCredentialsDocument(curr)
            // PackedPolicySize com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$PackedPolicySize
            "PackedPolicySize" -> builder.packedPolicySize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)" }
            // Provider com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Provider
            "Provider" -> builder.provider = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#Issuer`)" }
            // SourceIdentity com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$SourceIdentity
            "SourceIdentity" -> builder.sourceIdentity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#sourceIdentityType`)" }
            // SubjectFromWebIdentityToken com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$SubjectFromWebIdentityToken
            "SubjectFromWebIdentityToken" -> builder.subjectFromWebIdentityToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#webIdentitySubjectType`)" }
            else -> {}
        }
        curr.drop()
    }
}
