// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeCredentialsDocument(reader: XmlTagReader): Credentials {
    val builder = Credentials.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessKeyId com.amazonaws.sts#Credentials$AccessKeyId
            "AccessKeyId" -> builder.accessKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#accessKeyIdType`)" }
            // SecretAccessKey com.amazonaws.sts#Credentials$SecretAccessKey
            "SecretAccessKey" -> builder.secretAccessKey = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#accessKeySecretType`)" }
            // SessionToken com.amazonaws.sts#Credentials$SessionToken
            "SessionToken" -> builder.sessionToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#tokenType`)" }
            // Expiration com.amazonaws.sts#Credentials$Expiration
            "Expiration" -> builder.expiration = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.sts#dateType`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
