/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.CanonicalizerKt;
import aws.smithy.kotlin.runtime.net.url.QueryParameters;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.net.url.UrlPath;
import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\f\u001a\u00020\u0006*\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\rH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0006*\u00020\u0010H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"STREAM_CHUNK_BYTES", "", "multipleSpaces", "Lkotlin/text/Regex;", "skipHeaders", "", "", "includeHeader", "", "name", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "canonicalLine", "Lkotlin/Pair;", "", "canonicalPath", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "canonicalQueryParams", "trimAll", "aws-signing-default"})
public final class CanonicalizerKt {
    @NotNull
    private static final Set<String> skipHeaders;
    private static final int STREAM_CHUNK_BYTES = 16384;
    @NotNull
    private static final Regex multipleSpaces;

    @NotNull
    public static final String canonicalPath(@NotNull Url.Builder $this$canonicalPath, @NotNull AwsSigningConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$canonicalPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        UrlPath.Builder srcPath = $this$canonicalPath.getPath();
        List srcSegments = srcPath.getSegments();
        Function1 mapper2 = config.getUseDoubleUriEncode() ? (Function1)canonicalPath.mapper.1.INSTANCE : (Function1)canonicalPath.mapper.2.INSTANCE;
        return UrlPath.Companion.invoke((Function1)new Function1<UrlPath.Builder, Unit>((List<Encodable>)srcSegments, (Function1<? super Encodable, Encodable>)mapper2, srcPath, config){
            final /* synthetic */ List<Encodable> $srcSegments;
            final /* synthetic */ Function1<Encodable, Encodable> $mapper;
            final /* synthetic */ UrlPath.Builder $srcPath;
            final /* synthetic */ AwsSigningConfig $config;
            {
                this.$srcSegments = $srcSegments;
                this.$mapper = $mapper;
                this.$srcPath = $srcPath;
                this.$config = $config;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UrlPath.Builder $this$invoke) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Iterable iterable = this.$srcSegments;
                Collection collection = $this$invoke.getSegments();
                Function1<Encodable, Encodable> transform$iv = this.$mapper;
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void destination$iv;
                    destination$iv.add(transform$iv.invoke(item$iv));
                }
                $this$invoke.setTrailingSlash(this.$srcPath.getTrailingSlash());
                if (this.$config.getNormalizeUriPath()) {
                    $this$invoke.normalize();
                }
            }
        }).toString();
    }

    @NotNull
    public static final String canonicalQueryParams(@NotNull Url.Builder $this$canonicalQueryParams) {
        Intrinsics.checkNotNullParameter((Object)$this$canonicalQueryParams, (String)"<this>");
        return StringsKt.removePrefix((String)QueryParameters.Companion.invoke((Function1)new Function1<QueryParameters.Builder, Unit>($this$canonicalQueryParams){
            final /* synthetic */ Url.Builder $this_canonicalQueryParams;
            {
                this.$this_canonicalQueryParams = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull QueryParameters.Builder $this$invoke) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                Iterable $this$associate$iv = this.$this_canonicalQueryParams.getParameters().entrySet();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    Map map = destination$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    Encodable key = (Encodable)entry.getKey();
                    List values = (List)entry.getValue();
                    Encodable reencodedKey = key.reencode(PercentEncoding.Companion.getSigV4());
                    Iterable $this$map$iv = values;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Encodable encodable = (Encodable)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(it.reencode(PercentEncoding.Companion.getSigV4()));
                    }
                    List reencodedValues = (List)destination$iv$iv2;
                    entry = TuplesKt.to((Object)reencodedKey, (Object)reencodedValues);
                    map.put(entry.getFirst(), entry.getSecond());
                }
                Iterable $this$associateTo$iv = CollectionsKt.sortedWith((Iterable)destination$iv$iv.entrySet(), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((Encodable)it.getKey()).getEncoded());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Encodable)it.getKey()).getEncoded())));
                    }
                });
                boolean $i$f$associateTo2 = false;
                for (T element$iv : $this$associateTo$iv) {
                    Map map = (Map)$this$invoke;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Encodable key = (Encodable)entry.getKey();
                    List values = (List)entry.getValue();
                    entry = TuplesKt.to((Object)key, (Object)CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)values, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Encodable it = (Encodable)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getEncoded());
                            it = (Encodable)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getEncoded())));
                        }
                    })));
                    map.put(entry.getFirst(), entry.getSecond());
                }
                Map cfr_ignored_0 = (Map)$this$invoke;
            }
        }).toString(), (CharSequence)"?");
    }

    private static final String canonicalLine(Pair<String, ? extends List<String>> $this$canonicalLine) {
        String valuesString2 = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$canonicalLine.getSecond()), (CharSequence)",", null, null, (int)0, null, (Function1)canonicalLine.valuesString.1.INSTANCE, (int)30, null);
        return (String)$this$canonicalLine.getFirst() + ':' + valuesString2;
    }

    private static final String trimAll(String $this$trimAll) {
        CharSequence charSequence = $this$trimAll;
        Regex regex = multipleSpaces;
        String string = " ";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    private static final boolean includeHeader(String name, AwsSigningConfig config) {
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return !skipHeaders.contains(string) && (Boolean)config.getShouldSignHeader().invoke((Object)name) != false;
    }

    public static final /* synthetic */ boolean access$includeHeader(String name, AwsSigningConfig config) {
        return CanonicalizerKt.includeHeader(name, config);
    }

    public static final /* synthetic */ String access$canonicalLine(Pair $receiver) {
        return CanonicalizerKt.canonicalLine((Pair<String, ? extends List<String>>)$receiver);
    }

    public static final /* synthetic */ String access$trimAll(String $receiver) {
        return CanonicalizerKt.trimAll($receiver);
    }

    static {
        Object[] objectArray = new String[]{"connection", "expect", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "upgrade", "user-agent", "x-amzn-trace-id"};
        skipHeaders = SetsKt.setOf((Object[])objectArray);
        multipleSpaces = new Regex(" +");
    }
}

