/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.text;

import aws.smithy.kotlin.runtime.InternalApi;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0011\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0087\b\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"MAX_CODEPOINT", "", "SUPPLEMENTARY_PLANE_LOW", "byteCountUtf8", "start", "", "codePointToChars", "", "Lkotlin/Char$Companion;", "codePoint", "isSupplementaryCodePoint", "", "runtime-core"})
public final class Utf8Kt {
    private static final int SUPPLEMENTARY_PLANE_LOW = 65536;
    private static final int MAX_CODEPOINT = 0x10FFFF;

    @InternalApi
    public static final int byteCountUtf8(byte start) {
        int n;
        boolean $i$f$byteCountUtf8 = false;
        int x = UInt.constructor-impl((int)start);
        if (Integer.compareUnsigned(x, 127) <= 0) {
            n = 1;
        } else if (UInt.constructor-impl((int)(x & 0xE0)) == 192) {
            n = 2;
        } else if (UInt.constructor-impl((int)(x & 0xF0)) == 224) {
            n = 3;
        } else if (UInt.constructor-impl((int)(x & 0xF8)) == 240) {
            n = 4;
        } else {
            throw new IllegalStateException(start + " is not a valid UTF-8 start sequence");
        }
        return n;
    }

    @InternalApi
    public static final boolean isSupplementaryCodePoint(@NotNull CharCompanionObject $this$isSupplementaryCodePoint, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupplementaryCodePoint, (String)"<this>");
        return 65536 <= codePoint ? codePoint < 0x110000 : false;
    }

    @InternalApi
    @NotNull
    public static final char[] codePointToChars(@NotNull CharCompanionObject $this$codePointToChars, int codePoint) {
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)$this$codePointToChars, (String)"<this>");
        int n = codePoint;
        boolean bl = 0 <= n ? n < 65536 : false;
        if (bl) {
            char[] cArray2 = new char[]{(char)codePoint};
            cArray = cArray2;
        } else {
            boolean bl2 = 65536 <= n ? n < 0x110000 : false;
            if (bl2) {
                int low = 56320 + (codePoint - 65536 & 0x3FF);
                int high = 55296 + (codePoint - 65536 >>> 10 & 0x3FF);
                char[] cArray3 = new char[]{(char)high, (char)low};
                cArray = cArray3;
            } else {
                throw new IllegalArgumentException("invalid codepoint " + codePoint);
            }
        }
        return cArray;
    }
}

