/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.text.encoding;

import aws.smithy.kotlin.runtime.text.encoding.Encoding;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "", "decoded", "", "encoded", "encoding", "Laws/smithy/kotlin/runtime/text/encoding/Encoding;", "(Ljava/lang/String;Ljava/lang/String;Laws/smithy/kotlin/runtime/text/encoding/Encoding;)V", "getDecoded", "()Ljava/lang/String;", "getEncoded", "getEncoding", "()Laws/smithy/kotlin/runtime/text/encoding/Encoding;", "isEmpty", "", "()Z", "isNotEmpty", "equals", "other", "hashCode", "", "reencode", "newEncoding", "toString", "Companion", "runtime-core"})
public final class Encodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String decoded;
    @NotNull
    private final String encoded;
    @NotNull
    private final Encoding encoding;
    private final boolean isEmpty;
    private final boolean isNotEmpty;
    @NotNull
    private static final Encodable Empty = new Encodable("", "", Encoding.Companion.getNone$runtime_core());

    public Encodable(@NotNull String decoded, @NotNull String encoded, @NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)decoded, (String)"decoded");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        this.decoded = decoded;
        this.encoded = encoded;
        this.encoding = encoding;
        this.isEmpty = ((CharSequence)this.decoded).length() == 0 && ((CharSequence)this.encoded).length() == 0;
        this.isNotEmpty = !this.isEmpty;
    }

    @NotNull
    public final String getDecoded() {
        return this.decoded;
    }

    @NotNull
    public final String getEncoded() {
        return this.encoded;
    }

    @NotNull
    public final Encoding getEncoding() {
        return this.encoding;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final boolean isNotEmpty() {
        return this.isNotEmpty;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Encodable)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.decoded, (Object)((Encodable)other).decoded)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.encoded, (Object)((Encodable)other).encoded);
    }

    public int hashCode() {
        int result = this.decoded.hashCode();
        result = 31 * result + this.encoded.hashCode();
        return result;
    }

    @NotNull
    public final Encodable reencode() {
        return this.reencode(this.encoding);
    }

    @NotNull
    public final Encodable reencode(@NotNull Encoding newEncoding) {
        Intrinsics.checkNotNullParameter((Object)newEncoding, (String)"newEncoding");
        return newEncoding.encodableFromDecoded(this.decoded);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("Encodable(decoded=");
        $this$toString_u24lambda_u240.append(this.decoded);
        $this$toString_u24lambda_u240.append(", encoded=");
        $this$toString_u24lambda_u240.append(this.encoded);
        $this$toString_u24lambda_u240.append(", encoding=");
        $this$toString_u24lambda_u240.append(this.encoding.getName());
        $this$toString_u24lambda_u240.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/text/encoding/Encodable$Companion;", "", "()V", "Empty", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getEmpty", "()Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Encodable getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

