/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.time;

import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.ParsedDatetime;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"buildRfc5322Formatter", "Ljava/time/format/DateTimeFormatter;", "fromParsedDateTime", "Laws/smithy/kotlin/runtime/time/Instant;", "parsed", "Laws/smithy/kotlin/runtime/time/ParsedDatetime;", "runtime-core"})
public final class InstantJVMKt {
    private static final Instant fromParsedDateTime(ParsedDatetime parsed) {
        List list;
        Object[] objectArray;
        if (parsed.getHour() == 24 && parsed.getMin() == 0 && parsed.getSec() == 0) {
            objectArray = new Integer[]{1, 0, 0, 0};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (parsed.getHour() == 23 && parsed.getMin() == 59 && parsed.getSec() == 60) {
            objectArray = new Integer[]{0, 23, 59, 59};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new Integer[]{0, parsed.getHour(), parsed.getMin(), parsed.getSec()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List list2 = list;
        int dayOffset = ((Number)list2.get(0)).intValue();
        int hour = ((Number)list2.get(1)).intValue();
        int min = ((Number)list2.get(2)).intValue();
        int sec = ((Number)list2.get(3)).intValue();
        LocalDateTime ldt = LocalDateTime.of(parsed.getYear(), parsed.getMonth(), parsed.getDay(), hour, min, sec, parsed.getNs()).plusDays(dayOffset);
        ZoneOffset tzOffset = ZoneOffset.ofTotalSeconds(parsed.getOffsetSec());
        OffsetDateTime odt = ldt.atOffset(tzOffset);
        java.time.Instant asInstant = odt.toInstant();
        Intrinsics.checkNotNull((Object)asInstant);
        return new Instant(asInstant);
    }

    private static final DateTimeFormatter buildRfc5322Formatter() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1L, (Object)"Mon"), TuplesKt.to((Object)2L, (Object)"Tue"), TuplesKt.to((Object)3L, (Object)"Wed"), TuplesKt.to((Object)4L, (Object)"Thu"), TuplesKt.to((Object)5L, (Object)"Fri"), TuplesKt.to((Object)6L, (Object)"Sat"), TuplesKt.to((Object)7L, (Object)"Sun")};
        Map dow = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)1L, (Object)"Jan"), TuplesKt.to((Object)2L, (Object)"Feb"), TuplesKt.to((Object)3L, (Object)"Mar"), TuplesKt.to((Object)4L, (Object)"Apr"), TuplesKt.to((Object)5L, (Object)"May"), TuplesKt.to((Object)6L, (Object)"Jun"), TuplesKt.to((Object)7L, (Object)"Jul"), TuplesKt.to((Object)8L, (Object)"Aug"), TuplesKt.to((Object)9L, (Object)"Sep"), TuplesKt.to((Object)10L, (Object)"Oct"), TuplesKt.to((Object)11L, (Object)"Nov"), TuplesKt.to((Object)12L, (Object)"Dec")};
        Map moy = MapsKt.mapOf((Pair[])pairArray2);
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dow).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, moy).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter();
        DateTimeFormatter dateTimeFormatter = formatter.withChronology(IsoChronology.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withChronology(...)");
        return dateTimeFormatter;
    }

    public static final /* synthetic */ Instant access$fromParsedDateTime(ParsedDatetime parsed) {
        return InstantJVMKt.fromParsedDateTime(parsed);
    }

    public static final /* synthetic */ DateTimeFormatter access$buildRfc5322Formatter() {
        return InstantJVMKt.buildRfc5322Formatter();
    }
}

