/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Laws/smithy/kotlin/runtime/io/GzipSdkSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "source", "(Laws/smithy/kotlin/runtime/io/SdkSource;)V", "gzipBuffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "gzipOutputStream", "Ljava/util/zip/GZIPOutputStream;", "close", "", "read", "", "sink", "limit", "runtime-core"})
public final class GzipSdkSource
implements SdkSource {
    @NotNull
    private final SdkSource source;
    @NotNull
    private final SdkBuffer gzipBuffer;
    @NotNull
    private final GZIPOutputStream gzipOutputStream;

    public GzipSdkSource(@NotNull SdkSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.gzipBuffer = new SdkBuffer();
        this.gzipOutputStream = new GZIPOutputStream(this.gzipBuffer.outputStream(), true);
    }

    @Override
    public long read(@NotNull SdkBuffer sink, long limit) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!(limit >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (limit == 0L) {
            return 0L;
        }
        SdkBuffer temp = new SdkBuffer();
        long rc = this.source.read(temp, limit);
        if (rc == -1L) {
            this.gzipOutputStream.close();
        }
        if (rc == -1L && this.gzipBuffer.exhausted()) {
            return -1L;
        }
        if (rc >= 0L) {
            this.gzipOutputStream.write(temp.readByteArray());
            this.gzipOutputStream.flush();
        }
        return this.gzipBuffer.read(sink, limit);
    }

    @Override
    public void close() {
        this.gzipOutputStream.close();
        this.source.close();
    }
}

