/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.net.HostAddress;
import aws.smithy.kotlin.runtime.net.IpAddr;
import aws.smithy.kotlin.runtime.net.IpV4Addr;
import aws.smithy.kotlin.runtime.net.IpV6Addr;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0001H\u0007\u00a8\u0006\u0004"}, d2={"toHostAddress", "Laws/smithy/kotlin/runtime/net/HostAddress;", "Ljava/net/InetAddress;", "toInetAddress", "runtime-core"})
public final class DefaultHostResolverJVMKt {
    @InternalApi
    @NotNull
    public static final HostAddress toHostAddress(@NotNull InetAddress $this$toHostAddress) {
        IpAddr ipAddr;
        Intrinsics.checkNotNullParameter((Object)$this$toHostAddress, (String)"<this>");
        InetAddress inetAddress = $this$toHostAddress;
        if (inetAddress instanceof Inet4Address) {
            byte[] byArray = ((Inet4Address)$this$toHostAddress).getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
            ipAddr = new IpV4Addr(byArray);
        } else if (inetAddress instanceof Inet6Address) {
            byte[] byArray = ((Inet6Address)$this$toHostAddress).getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
            ipAddr = new IpV6Addr(byArray, null, 2, null);
        } else {
            throw new IllegalStateException(("unrecognized InetAddress " + $this$toHostAddress).toString());
        }
        IpAddr ipAddr2 = ipAddr;
        String string = $this$toHostAddress.getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
        return new HostAddress(string, ipAddr2);
    }

    @InternalApi
    @NotNull
    public static final InetAddress toInetAddress(@NotNull HostAddress $this$toInetAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$toInetAddress, (String)"<this>");
        InetAddress inetAddress = InetAddress.getByAddress($this$toInetAddress.getHostname(), $this$toInetAddress.getAddress().getOctets());
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(...)");
        return inetAddress;
    }
}

