/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.net.url;

import aws.smithy.kotlin.runtime.net.Host;
import aws.smithy.kotlin.runtime.net.HostKt;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.QueryParameters;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.net.url.UrlEncoding;
import aws.smithy.kotlin.runtime.net.url.UrlKt;
import aws.smithy.kotlin.runtime.net.url.UrlPath;
import aws.smithy.kotlin.runtime.net.url.UserInfo;
import aws.smithy.kotlin.runtime.text.Scanner;
import aws.smithy.kotlin.runtime.text.TextKt;
import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.Encoding;
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding;
import aws.smithy.kotlin.runtime.util.CanDeepCopy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u000201BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J!\u0010$\u001a\u00020\u00002\u0019\b\u0002\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&\u00a2\u0006\u0002\b)J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020\u0007H\u0016J\u0006\u0010.\u001a\u00020'J\b\u0010/\u001a\u00020\u0012H\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00062"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url;", "", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "host", "Laws/smithy/kotlin/runtime/net/Host;", "port", "", "path", "Laws/smithy/kotlin/runtime/net/url/UrlPath;", "parameters", "Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "userInfo", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "fragment", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "(Laws/smithy/kotlin/runtime/net/Scheme;Laws/smithy/kotlin/runtime/net/Host;ILaws/smithy/kotlin/runtime/net/url/UrlPath;Laws/smithy/kotlin/runtime/net/url/QueryParameters;Laws/smithy/kotlin/runtime/net/url/UserInfo;Laws/smithy/kotlin/runtime/text/encoding/Encodable;)V", "encoded", "", "getFragment", "()Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "getHost", "()Laws/smithy/kotlin/runtime/net/Host;", "getParameters", "()Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "getPath", "()Laws/smithy/kotlin/runtime/net/url/UrlPath;", "getPort", "()I", "requestRelativePath", "getRequestRelativePath", "()Ljava/lang/String;", "getScheme", "()Laws/smithy/kotlin/runtime/net/Scheme;", "getUserInfo", "()Laws/smithy/kotlin/runtime/net/url/UserInfo;", "copy", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "", "Lkotlin/ExtensionFunctionType;", "equals", "", "other", "hashCode", "toBuilder", "toString", "Builder", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheme scheme;
    @NotNull
    private final Host host;
    private final int port;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final QueryParameters parameters;
    @NotNull
    private final UserInfo userInfo;
    @Nullable
    private final Encodable fragment;
    @NotNull
    private final String encoded;
    @NotNull
    private final String requestRelativePath;

    private Url(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.userInfo = userInfo;
        this.fragment = fragment;
        int n = this.port;
        if (!(1 <= n ? n < 65536 : false)) {
            boolean $i$a$-require-Url$22 = false;
            String $i$a$-require-Url$22 = "Given port " + this.port + " is not in required range [1, 65535]";
            throw new IllegalArgumentException($i$a$-require-Url$22.toString());
        }
        Pair it = Url.Companion.stringify(this.scheme, this.host, this.port, this.path, this.parameters, this.userInfo, this.fragment);
        boolean bl = false;
        this.encoded = (String)it.getFirst();
        this.requestRelativePath = (String)it.getSecond();
    }

    @NotNull
    public final Scheme getScheme() {
        return this.scheme;
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public final QueryParameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Nullable
    public final Encodable getFragment() {
        return this.fragment;
    }

    @NotNull
    public final String getRequestRelativePath() {
        return this.requestRelativePath;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this);
    }

    @NotNull
    public final Url copy(@NotNull Function1<? super Builder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Builder builder = this.toBuilder();
        block.invoke((Object)builder);
        return builder.build();
    }

    public static /* synthetic */ Url copy$default(Url url, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = copy.1.INSTANCE;
        }
        return url.copy((Function1<? super Builder, Unit>)function1);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Url cfr_ignored_0 = (Url)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)((Url)other).scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)((Url)other).host)) {
            return false;
        }
        if (this.port != ((Url)other).port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)((Url)other).path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameters, (Object)((Url)other).parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userInfo, (Object)((Url)other).userInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fragment, (Object)((Url)other).fragment);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.userInfo.hashCode();
        Encodable encodable = this.fragment;
        result = 31 * result + (encodable != null ? encodable.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return this.encoded;
    }

    public /* synthetic */ Url(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment, DefaultConstructorMarker $constructor_marker) {
        this(scheme, host, port, path, parameters, userInfo, fragment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u00104\u001a\u00020\u0004J\u000e\u00105\u001a\u0002062\u0006\u0010\u0003\u001a\u00020\u0004J\b\u00107\u001a\u00020\u0000H\u0016J\u001f\u0010\u0018\u001a\u0002062\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020609\u00a2\u0006\u0002\b:J\u001d\u0010;\u001a\u0002062\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\u001f\u0010\u001e\u001a\u0002062\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020609\u00a2\u0006\u0002\b:J\u001f\u00100\u001a\u0002062\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020609\u00a2\u0006\u0002\b:R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010(\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006?"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "Laws/smithy/kotlin/runtime/util/CanDeepCopy;", "()V", "url", "Laws/smithy/kotlin/runtime/net/url/Url;", "(Laws/smithy/kotlin/runtime/net/url/Url;)V", "value", "", "decodedFragment", "getDecodedFragment", "()Ljava/lang/String;", "setDecodedFragment", "(Ljava/lang/String;)V", "encodedFragment", "getEncodedFragment", "setEncodedFragment", "fragment", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "host", "Laws/smithy/kotlin/runtime/net/Host;", "getHost", "()Laws/smithy/kotlin/runtime/net/Host;", "setHost", "(Laws/smithy/kotlin/runtime/net/Host;)V", "parameters", "Laws/smithy/kotlin/runtime/net/url/QueryParameters$Builder;", "getParameters", "()Laws/smithy/kotlin/runtime/net/url/QueryParameters$Builder;", "<set-?>", "Laws/smithy/kotlin/runtime/net/url/UrlPath$Builder;", "path", "getPath", "()Laws/smithy/kotlin/runtime/net/url/UrlPath$Builder;", "port", "", "getPort", "()Ljava/lang/Integer;", "setPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "requestRelativePath", "getRequestRelativePath", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "getScheme", "()Laws/smithy/kotlin/runtime/net/Scheme;", "setScheme", "(Laws/smithy/kotlin/runtime/net/Scheme;)V", "userInfo", "Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "getUserInfo", "()Laws/smithy/kotlin/runtime/net/url/UserInfo$Builder;", "build", "copyFrom", "", "deepCopy", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "parseFragment", "encoding", "Laws/smithy/kotlin/runtime/net/url/UrlEncoding;", "parseFragment$runtime_core", "runtime-core"})
    @SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\naws/smithy/kotlin/runtime/net/url/Url$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
    public static final class Builder
    implements CanDeepCopy<Builder> {
        @NotNull
        private Scheme scheme;
        @NotNull
        private Host host;
        @Nullable
        private Integer port;
        @NotNull
        private UrlPath.Builder path;
        @NotNull
        private final QueryParameters.Builder parameters;
        @NotNull
        private final UserInfo.Builder userInfo;
        @Nullable
        private Encodable fragment;

        public Builder(@Nullable Url url) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = url;
            if (object4 == null || (object4 = ((Url)object4).getScheme()) == null) {
                object4 = this.scheme = Scheme.Companion.getHTTPS();
            }
            if ((object3 = url) == null || (object3 = ((Url)object3).getHost()) == null) {
                object3 = new Host.Domain("");
            }
            this.host = object3;
            Url url2 = url;
            this.port = url2 != null ? Integer.valueOf(url2.getPort()) : null;
            Object object5 = url;
            if (object5 == null || (object5 = ((Url)object5).getPath()) == null || (object5 = ((UrlPath)object5).toBuilder()) == null) {
                object5 = this.path = new UrlPath.Builder();
            }
            if ((object2 = url) == null || (object2 = ((Url)object2).getParameters()) == null || (object2 = ((QueryParameters)object2).toBuilder()) == null) {
                object2 = this.parameters = new QueryParameters.Builder();
            }
            if ((object = url) == null || (object = ((Url)object).getUserInfo()) == null || (object = ((UserInfo)object).toBuilder()) == null) {
                object = new UserInfo.Builder();
            }
            this.userInfo = object;
            Url url3 = url;
            this.fragment = url3 != null ? url3.getFragment() : null;
        }

        public Builder() {
            this(null);
        }

        @NotNull
        public final Scheme getScheme() {
            return this.scheme;
        }

        public final void setScheme(@NotNull Scheme scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"<set-?>");
            this.scheme = scheme;
        }

        @NotNull
        public final Host getHost() {
            return this.host;
        }

        public final void setHost(@NotNull Host host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"<set-?>");
            this.host = host;
        }

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(@Nullable Integer n) {
            this.port = n;
        }

        @NotNull
        public final UrlPath.Builder getPath() {
            return this.path;
        }

        public final void path(@NotNull Function1<? super UrlPath.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            UrlPath.Builder builder = this.path;
            block.invoke((Object)builder);
        }

        @NotNull
        public final QueryParameters.Builder getParameters() {
            return this.parameters;
        }

        public final void parameters(@NotNull Function1<? super QueryParameters.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            QueryParameters.Builder builder = this.parameters;
            block.invoke((Object)builder);
        }

        @NotNull
        public final UserInfo.Builder getUserInfo() {
            return this.userInfo;
        }

        public final void userInfo(@NotNull Function1<? super UserInfo.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            UserInfo.Builder builder = this.userInfo;
            block.invoke((Object)builder);
        }

        public final void parseFragment$runtime_core(@NotNull String value, @NotNull UrlEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            if (encoding.contains(UrlEncoding.Fragment.INSTANCE)) {
                this.setEncodedFragment(value);
            } else {
                this.setDecodedFragment(value);
            }
        }

        @Nullable
        public final String getDecodedFragment() {
            Encodable encodable = this.fragment;
            return encodable != null ? encodable.getDecoded() : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDecodedFragment(@Nullable String value) {
            Encodable encodable;
            Builder builder = this;
            String string = value;
            if (string != null) {
                void p0;
                String string2 = string;
                Encoding encoding = PercentEncoding.Companion.getFragment();
                String string3 = string2;
                Builder builder2 = builder;
                boolean bl = false;
                encodable = encoding.encodableFromDecoded((String)p0);
                builder = builder2;
            } else {
                encodable = null;
            }
            builder.fragment = encodable;
        }

        @Nullable
        public final String getEncodedFragment() {
            Encodable encodable = this.fragment;
            return encodable != null ? encodable.getEncoded() : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedFragment(@Nullable String value) {
            Encodable encodable;
            Builder builder = this;
            String string = value;
            if (string != null) {
                void p0;
                String string2 = string;
                Encoding encoding = PercentEncoding.Companion.getFragment();
                String string3 = string2;
                Builder builder2 = builder;
                boolean bl = false;
                encodable = encoding.encodableFromEncoded((String)p0);
                builder = builder2;
            } else {
                encodable = null;
            }
            builder.fragment = encodable;
        }

        @NotNull
        public final Url build() {
            Integer n = this.port;
            return new Url(this.scheme, this.host, n != null ? n.intValue() : this.scheme.getDefaultPort(), this.path.build(), this.parameters.build(), this.userInfo.build(), this.fragment, null);
        }

        @Override
        @NotNull
        public Builder deepCopy() {
            Builder builder;
            Builder it = builder = new Builder();
            boolean bl = false;
            it.scheme = this.scheme;
            it.host = this.host;
            it.port = this.port;
            it.path.copyFrom(this.path);
            it.parameters.copyFrom(this.parameters);
            it.userInfo.copyFrom(this.userInfo);
            it.fragment = this.fragment;
            return builder;
        }

        public final void copyFrom(@NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.scheme = url.getScheme();
            this.host = url.getHost();
            this.port = url.getPort();
            this.path.copyFrom(url.getPath());
            this.parameters.copyFrom(url.getParameters());
            this.userInfo.copyFrom(url.getUserInfo());
            this.fragment = url.getFragment();
        }

        @NotNull
        public final String getRequestRelativePath() {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_requestRelativePath__u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$_get_requestRelativePath__u24lambda_u243.append(this.path.getEncoded());
            $this$_get_requestRelativePath__u24lambda_u243.append(this.parameters.getEncoded());
            Encodable encodable = this.fragment;
            if (encodable != null) {
                Encodable it = encodable;
                boolean bl2 = false;
                $this$_get_requestRelativePath__u24lambda_u243.append('#');
                $this$_get_requestRelativePath__u24lambda_u243.append(it.getEncoded());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return TextKt.ensurePrefix(string, "/");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0086\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJN\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Laws/smithy/kotlin/runtime/net/url/Url$Companion;", "", "()V", "invoke", "Laws/smithy/kotlin/runtime/net/url/Url;", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/net/url/Url$Builder;", "", "Lkotlin/ExtensionFunctionType;", "parse", "value", "", "encoding", "Laws/smithy/kotlin/runtime/net/url/UrlEncoding;", "stringify", "Lkotlin/Pair;", "scheme", "Laws/smithy/kotlin/runtime/net/Scheme;", "host", "Laws/smithy/kotlin/runtime/net/Host;", "port", "", "path", "Laws/smithy/kotlin/runtime/net/url/UrlPath;", "parameters", "Laws/smithy/kotlin/runtime/net/url/QueryParameters;", "userInfo", "Laws/smithy/kotlin/runtime/net/url/UserInfo;", "fragment", "Laws/smithy/kotlin/runtime/text/encoding/Encodable;", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Url invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        @NotNull
        public final Url parse(@NotNull String value, @NotNull UrlEncoding encoding) {
            Url url;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            try {
                url = Companion.invoke((Function1<? super Builder, Unit>)((Function1)new Function1<Builder, Unit>(value, encoding){
                    final /* synthetic */ String $value;
                    final /* synthetic */ UrlEncoding $encoding;
                    {
                        this.$value = $value;
                        this.$encoding = $encoding;
                        super(1);
                    }

                    public final void invoke(@NotNull Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        Scanner scanner = new Scanner(this.$value);
                        String[] stringArray = new String[]{"://"};
                        scanner.requireAndSkip(stringArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$invoke){
                            final /* synthetic */ Builder $this_invoke;
                            {
                                this.$this_invoke = $this_invoke;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$this_invoke.setScheme(Scheme.Companion.parse(it));
                            }
                        }));
                        stringArray = new String[]{"@"};
                        scanner.optionalAndSkip(stringArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$invoke){
                            final /* synthetic */ Builder $this_invoke;
                            {
                                this.$this_invoke = $this_invoke;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$this_invoke.getUserInfo().parseEncoded$runtime_core(it);
                            }
                        }));
                        stringArray = new String[]{"/", "?", "#"};
                        scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($this$invoke){
                            final /* synthetic */ Builder $this_invoke;
                            {
                                this.$this_invoke = $this_invoke;
                                super(1);
                            }

                            public final void invoke(@NotNull String authority) {
                                block0: {
                                    Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
                                    Pair pair = UrlKt.access$parseHostPort(authority);
                                    Host h = (Host)pair.component1();
                                    Integer p = (Integer)pair.component2();
                                    this.$this_invoke.setHost(h);
                                    Integer n = p;
                                    if (n == null) break block0;
                                    Integer n2 = n;
                                    Builder builder = this.$this_invoke;
                                    int it = ((Number)n2).intValue();
                                    boolean bl = false;
                                    builder.setPort(it);
                                }
                            }
                        }));
                        scanner.ifStartsWith("/", (Function0<Unit>)((Function0)new Function0<Unit>(scanner, $this$invoke, this.$encoding){
                            final /* synthetic */ Scanner $scanner;
                            final /* synthetic */ Builder $this_invoke;
                            final /* synthetic */ UrlEncoding $encoding;
                            {
                                this.$scanner = $scanner;
                                this.$this_invoke = $this_invoke;
                                this.$encoding = $encoding;
                                super(0);
                            }

                            public final void invoke() {
                                String[] stringArray = new String[]{"?", "#"};
                                this.$scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$this_invoke, this.$encoding){
                                    final /* synthetic */ Builder $this_invoke;
                                    final /* synthetic */ UrlEncoding $encoding;
                                    {
                                        this.$this_invoke = $this_invoke;
                                        this.$encoding = $encoding;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$this_invoke.getPath().parse$runtime_core(it, this.$encoding);
                                    }
                                }));
                            }
                        }));
                        scanner.ifStartsWith("?", (Function0<Unit>)((Function0)new Function0<Unit>(scanner, $this$invoke, this.$encoding){
                            final /* synthetic */ Scanner $scanner;
                            final /* synthetic */ Builder $this_invoke;
                            final /* synthetic */ UrlEncoding $encoding;
                            {
                                this.$scanner = $scanner;
                                this.$this_invoke = $this_invoke;
                                this.$encoding = $encoding;
                                super(0);
                            }

                            public final void invoke() {
                                String[] stringArray = new String[]{"#"};
                                this.$scanner.upToOrEnd(stringArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$this_invoke, this.$encoding){
                                    final /* synthetic */ Builder $this_invoke;
                                    final /* synthetic */ UrlEncoding $encoding;
                                    {
                                        this.$this_invoke = $this_invoke;
                                        this.$encoding = $encoding;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$this_invoke.getParameters().parse$runtime_core(it, this.$encoding);
                                    }
                                }));
                            }
                        }));
                        scanner.ifStartsWithSkip("#", (Function0<Unit>)((Function0)new Function0<Unit>(scanner, $this$invoke, this.$encoding){
                            final /* synthetic */ Scanner $scanner;
                            final /* synthetic */ Builder $this_invoke;
                            final /* synthetic */ UrlEncoding $encoding;
                            {
                                this.$scanner = $scanner;
                                this.$this_invoke = $this_invoke;
                                this.$encoding = $encoding;
                                super(0);
                            }

                            public final void invoke() {
                                this.$scanner.upToOrEnd(new String[0], (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$this_invoke, this.$encoding){
                                    final /* synthetic */ Builder $this_invoke;
                                    final /* synthetic */ UrlEncoding $encoding;
                                    {
                                        this.$this_invoke = $this_invoke;
                                        this.$encoding = $encoding;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$this_invoke.parseFragment$runtime_core(it, this.$encoding);
                                    }
                                }));
                            }
                        }));
                    }
                }));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot parse \"" + value + "\" as a URL", e);
            }
            return url;
        }

        public static /* synthetic */ Url parse$default(Companion companion, String string, UrlEncoding urlEncoding, int n, Object object) {
            if ((n & 2) != 0) {
                urlEncoding = UrlEncoding.Companion.getAll();
            }
            return companion.parse(string, urlEncoding);
        }

        private final Pair<String, String> stringify(Scheme scheme, Host host, int port, UrlPath path, QueryParameters parameters, UserInfo userInfo, Encodable fragment) {
            StringBuilder stringBuilder;
            int splitAt = 0;
            StringBuilder $this$stringify_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$stringify_u24lambda_u241.append(scheme.getProtocolName());
            $this$stringify_u24lambda_u241.append("://");
            $this$stringify_u24lambda_u241.append(userInfo);
            $this$stringify_u24lambda_u241.append(HostKt.toUrlString(host));
            if (port != scheme.getDefaultPort()) {
                $this$stringify_u24lambda_u241.append(":");
                $this$stringify_u24lambda_u241.append(port);
            }
            splitAt = $this$stringify_u24lambda_u241.length();
            $this$stringify_u24lambda_u241.append(path);
            $this$stringify_u24lambda_u241.append(parameters);
            Encodable encodable = fragment;
            if (encodable != null) {
                Encodable it = encodable;
                boolean bl2 = false;
                $this$stringify_u24lambda_u241.append('#');
                $this$stringify_u24lambda_u241.append(it.getEncoded());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String encoded = string;
            String string2 = encoded.substring(splitAt);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String requestRelativePath = TextKt.ensurePrefix(string2, "/");
            return TuplesKt.to((Object)encoded, (Object)requestRelativePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

