/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.policy;

import aws.smithy.kotlin.runtime.ClientException;
import aws.smithy.kotlin.runtime.ErrorMetadata;
import aws.smithy.kotlin.runtime.SdkBaseException;
import aws.smithy.kotlin.runtime.ServiceErrorMetadata;
import aws.smithy.kotlin.runtime.ServiceException;
import aws.smithy.kotlin.runtime.retries.policy.EvaluationStrategy;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0007H\u0014R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/RetryPolicy;", "", "()V", "evaluationStrategies", "Lkotlin/sequences/Sequence;", "Laws/smithy/kotlin/runtime/retries/policy/EvaluationStrategy;", "", "evaluate", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "ex", "evaluateBaseException", "Laws/smithy/kotlin/runtime/SdkBaseException;", "evaluateClientException", "Laws/smithy/kotlin/runtime/ClientException;", "evaluateServiceException", "Laws/smithy/kotlin/runtime/ServiceException;", "evaluateSpecificExceptions", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nStandardRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardRetryPolicy.kt\naws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy\n+ 2 StandardRetryPolicy.kt\naws/smithy/kotlin/runtime/retries/policy/EvaluationStrategy$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n69#2:75\n69#2:76\n69#2:77\n69#2:78\n1#3:79\n*S KotlinDebug\n*F\n+ 1 StandardRetryPolicy.kt\naws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy\n*L\n24#1:75\n25#1:76\n26#1:77\n27#1:78\n*E\n"})
public class StandardRetryPolicy
implements RetryPolicy<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sequence<EvaluationStrategy<? extends Throwable>> evaluationStrategies;
    @NotNull
    private static final StandardRetryPolicy Default = new StandardRetryPolicy();

    public StandardRetryPolicy() {
        Object[] objectArray = new EvaluationStrategy[4];
        EvaluationStrategy.Companion companion = EvaluationStrategy.Companion;
        Function1 evaluator$iv = (Function1)new Function1<Throwable, RetryDirective>((Object)this){

            @Nullable
            public final RetryDirective invoke(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((StandardRetryPolicy)this.receiver).evaluateSpecificExceptions(p0);
            }
        };
        boolean $i$f$invoke = false;
        objectArray[0] = new EvaluationStrategy(Reflection.getOrCreateKotlinClass(Throwable.class), evaluator$iv);
        EvaluationStrategy.Companion this_$iv = EvaluationStrategy.Companion;
        evaluator$iv = (Function1)new Function1<ServiceException, RetryDirective>((Object)this){

            @Nullable
            public final RetryDirective invoke(@NotNull ServiceException p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return StandardRetryPolicy.access$evaluateServiceException((StandardRetryPolicy)this.receiver, p0);
            }
        };
        $i$f$invoke = false;
        objectArray[1] = new EvaluationStrategy(Reflection.getOrCreateKotlinClass(ServiceException.class), evaluator$iv);
        this_$iv = EvaluationStrategy.Companion;
        evaluator$iv = (Function1)new Function1<ClientException, RetryDirective>((Object)this){

            @Nullable
            public final RetryDirective invoke(@NotNull ClientException p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return StandardRetryPolicy.access$evaluateClientException((StandardRetryPolicy)this.receiver, p0);
            }
        };
        $i$f$invoke = false;
        objectArray[2] = new EvaluationStrategy(Reflection.getOrCreateKotlinClass(ClientException.class), evaluator$iv);
        this_$iv = EvaluationStrategy.Companion;
        evaluator$iv = (Function1)new Function1<SdkBaseException, RetryDirective>((Object)this){

            @Nullable
            public final RetryDirective invoke(@NotNull SdkBaseException p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return StandardRetryPolicy.access$evaluateBaseException((StandardRetryPolicy)this.receiver, p0);
            }
        };
        $i$f$invoke = false;
        objectArray[3] = new EvaluationStrategy(Reflection.getOrCreateKotlinClass(SdkBaseException.class), evaluator$iv);
        this.evaluationStrategies = SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public RetryDirective evaluate(@NotNull Object result) {
        RetryDirective retryDirective;
        if (Result.isSuccess-impl((Object)result)) {
            retryDirective = RetryDirective.TerminateAndSucceed.INSTANCE;
        } else {
            Throwable throwable = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable);
            retryDirective = this.evaluate(throwable);
        }
        return retryDirective;
    }

    private final RetryDirective evaluate(Throwable ex) {
        RetryDirective retryDirective;
        RetryDirective retryDirective2;
        block2: {
            for (EvaluationStrategy it : this.evaluationStrategies) {
                boolean bl = false;
                RetryDirective retryDirective3 = it.evaluate(ex);
                if (retryDirective3 == null) continue;
                retryDirective2 = retryDirective3;
                break block2;
            }
            retryDirective2 = retryDirective = null;
        }
        if (retryDirective2 == null) {
            retryDirective = RetryDirective.TerminateAndFail.INSTANCE;
        }
        return retryDirective;
    }

    private final RetryDirective evaluateBaseException(SdkBaseException ex) {
        ErrorMetadata $this$evaluateBaseException_u24lambda_u241 = ex.getSdkErrorMetadata();
        boolean bl = false;
        return $this$evaluateBaseException_u24lambda_u241.isThrottling() ? new RetryDirective.RetryError(RetryErrorType.Throttling) : ($this$evaluateBaseException_u24lambda_u241.isRetryable() ? new RetryDirective.RetryError(RetryErrorType.Transient) : null);
    }

    private final RetryDirective evaluateClientException(ClientException ex) {
        return ex.getSdkErrorMetadata().isRetryable() ? (RetryDirective)new RetryDirective.RetryError(RetryErrorType.ClientSide) : null;
    }

    private final RetryDirective evaluateServiceException(ServiceException ex) {
        ServiceErrorMetadata $this$evaluateServiceException_u24lambda_u242 = ex.getSdkErrorMetadata();
        boolean bl = false;
        return $this$evaluateServiceException_u24lambda_u242.isRetryable() && $this$evaluateServiceException_u24lambda_u242.getErrorType() == ServiceException.ErrorType.Server ? new RetryDirective.RetryError(RetryErrorType.ServerSide) : ($this$evaluateServiceException_u24lambda_u242.isRetryable() && $this$evaluateServiceException_u24lambda_u242.getErrorType() == ServiceException.ErrorType.Client ? new RetryDirective.RetryError(RetryErrorType.ClientSide) : null);
    }

    @Nullable
    protected RetryDirective evaluateSpecificExceptions(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return null;
    }

    public static final /* synthetic */ RetryDirective access$evaluateServiceException(StandardRetryPolicy $this, ServiceException ex) {
        return $this.evaluateServiceException(ex);
    }

    public static final /* synthetic */ RetryDirective access$evaluateClientException(StandardRetryPolicy $this, ClientException ex) {
        return $this.evaluateClientException(ex);
    }

    public static final /* synthetic */ RetryDirective access$evaluateBaseException(StandardRetryPolicy $this, SdkBaseException ex) {
        return $this.evaluateBaseException(ex);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy$Companion;", "", "()V", "Default", "Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "getDefault", "()Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StandardRetryPolicy getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

