/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.text.encoding;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.text.encoding.Encodable;
import aws.smithy.kotlin.runtime.text.encoding.Encoding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010$\n\u0002\b\u0010\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/text/encoding/PercentEncoding;", "Laws/smithy/kotlin/runtime/text/encoding/Encoding;", "name", "", "validChars", "", "", "specialMapping", "", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Map;)V", "asciiMapping", "decodeMap", "encodeMap", "getName", "()Ljava/lang/String;", "getSpecialMapping", "()Ljava/util/Map;", "getValidChars", "()Ljava/util/Set;", "decode", "encoded", "encode", "decoded", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nPercentEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PercentEncoding.kt\naws/smithy/kotlin/runtime/text/encoding/PercentEncoding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1549#2:159\n1620#2,3:160\n819#2:163\n847#2,2:164\n1271#2,2:166\n1285#2,4:168\n1238#2,4:174\n1271#2,2:178\n1285#2,4:180\n1179#2,2:184\n1253#2,4:186\n453#3:172\n403#3:173\n1#4:190\n*S KotlinDebug\n*F\n+ 1 PercentEncoding.kt\naws/smithy/kotlin/runtime/text/encoding/PercentEncoding\n*L\n102#1:159\n102#1:160,3\n103#1:163\n103#1:164,2\n104#1:166,2\n104#1:168,4\n106#1:174,4\n108#1:178,2\n108#1:180,4\n110#1:184,2\n110#1:186,4\n106#1:172\n106#1:173\n*E\n"})
public final class PercentEncoding
implements Encoding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Set<Character> validChars;
    @NotNull
    private final Map<Character, Character> specialMapping;
    @NotNull
    private final Map<Character, String> asciiMapping;
    @NotNull
    private final Map<Character, String> encodeMap;
    @NotNull
    private final Map<Character, Character> decodeMap;
    @NotNull
    private static final Set<Character> ALPHA = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Iterable)((Iterable)new CharRange('A', 'Z')), (Iterable)((Iterable)new CharRange('a', 'z'))));
    @NotNull
    private static final Set<Character> DIGIT = CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9')));
    @NotNull
    private static final Set<Character> UNRESERVED;
    @NotNull
    private static final Set<Character> SUB_DELIMS;
    @NotNull
    private static final Set<Character> VALID_UCHAR;
    @NotNull
    private static final Set<Character> VALID_PCHAR;
    @NotNull
    private static final Set<Character> VALID_FCHAR;
    @NotNull
    private static final Set<Character> VALID_QCHAR;
    @NotNull
    private static final Set<Character> SMITHY_LABEL_CHAR;
    @NotNull
    private static final Set<Character> SIGV4_SIGNING_CHAR;
    @NotNull
    private static final String UPPER_HEX = "0123456789ABCDEF";
    @NotNull
    private static final Encoding Host;
    @NotNull
    private static final Encoding UserInfo;
    @NotNull
    private static final Encoding Path;
    @NotNull
    private static final Encoding Query;
    @NotNull
    private static final Encoding Fragment;
    @NotNull
    private static final Encoding FormUrl;
    @NotNull
    private static final Encoding SmithyLabel;
    @NotNull
    private static final Encoding SigV4;

    /*
     * WARNING - void declaration
     */
    public PercentEncoding(@NotNull String name, @NotNull Set<Character> validChars, @NotNull Map<Character, Character> specialMapping) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapValuesTo$iv$iv;
        Iterable $this$mapValues$iv;
        Object object;
        Object object2;
        Object $this$associateWith$iv;
        char p0;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Map map2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(validChars, (String)"validChars");
        Intrinsics.checkNotNullParameter(specialMapping, (String)"specialMapping");
        this.name = name;
        this.validChars = validChars;
        this.specialMapping = specialMapping;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)128);
        PercentEncoding percentEncoding = this;
        boolean $i$f$map22 = false;
        void var6_9 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.add(Character.valueOf((char)p02));
        }
        $this$map$iv = (List)destination$iv$iv;
        Object $i$f$map22 = this.validChars;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            p0 = ((Character)element$iv$iv).charValue();
            boolean bl = false;
            if ($i$f$map22.contains(Character.valueOf(p0))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        $i$f$map22 = Companion;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            p0 = ((Character)element$iv$iv3).charValue();
            object2 = element$iv$iv3;
            map2 = result$iv;
            boolean bl = false;
            object = ((Companion)$i$f$map22).percentAsciiEncode(p0);
            map2.put(object2, (String)object);
        }
        percentEncoding.asciiMapping = result$iv;
        $this$associateWith$iv = this.specialMapping;
        map2 = this.asciiMapping;
        percentEncoding = this;
        boolean $i$f$mapValues = false;
        void $i$f$associateWith22 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        Iterator element$iv$iv3 = $this$associateByTo$iv$iv$iv.iterator();
        while (element$iv$iv3.hasNext()) {
            void it$iv$iv;
            Object element$iv$iv$iv = element$iv$iv3.next();
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            object2 = object3;
            boolean bl3 = false;
            char c = ((Character)entry.getValue()).charValue();
            String string = String.valueOf(c);
            object2.put((String)object, (String)string);
        }
        object2 = destination$iv$iv;
        percentEncoding.encodeMap = MapsKt.plus(map2, object2);
        $this$mapValues$iv = this.validChars;
        percentEncoding = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, (int)10)), (int)16));
        Map<Character, Character> $this$associateWithTo$iv$iv2 = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        $this$associateByTo$iv$iv$iv = $this$associateWithTo$iv$iv2.iterator();
        while ($this$associateByTo$iv$iv$iv.hasNext()) {
            void it;
            Object element$iv$iv2 = $this$associateByTo$iv$iv$iv.next();
            char element$iv$iv3 = ((Character)element$iv$iv2).charValue();
            object2 = element$iv$iv2;
            map2 = result$iv2;
            boolean bl = false;
            object = Character.valueOf((char)it);
            map2.put(object2, object);
        }
        $this$associateWith$iv = MapsKt.plus((Map)result$iv2, this.specialMapping).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateWithTo$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv4 : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv22;
            Map.Entry entry = (Map.Entry)element$iv$iv4;
            boolean bl = false;
            char decoded = ((Character)entry.getKey()).charValue();
            char encoded = ((Character)entry.getValue()).charValue();
            entry = TuplesKt.to((Object)Character.valueOf(encoded), (Object)Character.valueOf(decoded));
            map3.put(entry.getFirst(), entry.getSecond());
        }
        percentEncoding.decodeMap = destination$iv$iv22;
    }

    public /* synthetic */ PercentEncoding(String string, Set set, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string, set, map2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Set<Character> getValidChars() {
        return this.validChars;
    }

    @NotNull
    public final Map<Character, Character> getSpecialMapping() {
        return this.specialMapping;
    }

    @Override
    @NotNull
    public String decode(@NotNull String encoded) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        int n = encoded.length();
        StringBuilder $this$decode_u24lambda_u245 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        byte[] byteBuffer = null;
        int i = 0;
        char c = '\u0000';
        while (i < encoded.length()) {
            c = encoded.charAt(i);
            if (c == '%') {
                if (byteBuffer == null) {
                    byteBuffer = new byte[(encoded.length() - i) / 3];
                }
                int byteCount = 0;
                while (i + 2 < encoded.length() && c == '%') {
                    String string = encoded.substring(i + 1, i + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Integer n2 = StringsKt.toIntOrNull((String)string, (int)16);
                    if (n2 == null) {
                        break;
                    }
                    byte by = (byte)n2.intValue();
                    byteBuffer[byteCount++] = by;
                    if ((i += 3) >= encoded.length()) continue;
                    c = encoded.charAt(i);
                }
                $this$decode_u24lambda_u245.append(StringsKt.decodeToString$default((byte[])byteBuffer, (int)0, (int)byteCount, (boolean)false, (int)5, null));
                if (i == encoded.length() || c != '%') continue;
                $this$decode_u24lambda_u245.append(c);
                ++i;
                continue;
            }
            Character c2 = this.decodeMap.get(Character.valueOf(c));
            $this$decode_u24lambda_u245.append(c2 != null ? c2.charValue() : c);
            ++i;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String encode(@NotNull String decoded) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)decoded, (String)"decoded");
        int n = decoded.length();
        StringBuilder $this$encode_u24lambda_u247 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (byte by : StringsKt.encodeToByteArray((String)decoded)) {
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3;
            char c = (char)by;
            if (this.validChars.contains(Character.valueOf(c))) {
                $this$encode_u24lambda_u247.append(c);
                continue;
            }
            if (this.encodeMap.get(Character.valueOf(c)) != null) {
                String p0;
                boolean bl2 = false;
                stringBuilder3 = $this$encode_u24lambda_u247.append(p0);
            } else {
                stringBuilder3 = null;
            }
            StringBuilder stringBuilder4 = stringBuilder2 = stringBuilder3;
            if (stringBuilder4 == null) {
                PercentEncoding.Companion.percentEncode($this$encode_u24lambda_u247, by);
                continue;
            }
            Intrinsics.checkNotNull((Object)stringBuilder4);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Encodable encodableFromDecoded(@NotNull String decoded) {
        return Encoding.DefaultImpls.encodableFromDecoded(this, decoded);
    }

    @Override
    @NotNull
    public Encodable encodableFromEncoded(@NotNull String encoded) {
        return Encoding.DefaultImpls.encodableFromEncoded(this, encoded);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        UNRESERVED = SetsKt.plus((Set)SetsKt.plus(ALPHA, (Iterable)DIGIT), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('=')};
        SUB_DELIMS = SetsKt.setOf((Object[])objectArray);
        VALID_UCHAR = SetsKt.plus(UNRESERVED, (Iterable)SUB_DELIMS);
        objectArray = new Character[]{Character.valueOf(':'), Character.valueOf('@')};
        VALID_PCHAR = SetsKt.plus(VALID_UCHAR, (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Character[]{Character.valueOf('/'), Character.valueOf('?')};
        VALID_FCHAR = SetsKt.plus(VALID_PCHAR, (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Character[]{Character.valueOf('&'), Character.valueOf('=')};
        VALID_QCHAR = SetsKt.minus(VALID_FCHAR, (Iterable)SetsKt.setOf((Object[])objectArray));
        SMITHY_LABEL_CHAR = UNRESERVED;
        SIGV4_SIGNING_CHAR = UNRESERVED;
        Host = new PercentEncoding("host", SetsKt.plus(UNRESERVED, (Object)Character.valueOf(':')), null, 4, null);
        UserInfo = new PercentEncoding("user info", VALID_UCHAR, null, 4, null);
        Path = new PercentEncoding("path", VALID_PCHAR, null, 4, null);
        Query = new PercentEncoding("query string", VALID_QCHAR, null, 4, null);
        Fragment = new PercentEncoding("fragment", VALID_FCHAR, null, 4, null);
        FormUrl = new PercentEncoding("form URL", UNRESERVED, null, 4, null);
        SmithyLabel = new PercentEncoding("Smithy label", SMITHY_LABEL_CHAR, null, 4, null);
        SigV4 = new PercentEncoding("SigV4", SIGV4_SIGNING_CHAR, null, 4, null);
    }

    @InternalApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0018\u0010%\u001a\u00020&*\u00060'j\u0002`(2\u0006\u0010)\u001a\u00020*H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Laws/smithy/kotlin/runtime/text/encoding/PercentEncoding$Companion;", "", "()V", "ALPHA", "", "", "DIGIT", "FormUrl", "Laws/smithy/kotlin/runtime/text/encoding/Encoding;", "getFormUrl", "()Laws/smithy/kotlin/runtime/text/encoding/Encoding;", "Fragment", "getFragment", "Host", "getHost", "Path", "getPath", "Query", "getQuery", "SIGV4_SIGNING_CHAR", "SMITHY_LABEL_CHAR", "SUB_DELIMS", "SigV4", "getSigV4", "SmithyLabel", "getSmithyLabel", "UNRESERVED", "UPPER_HEX", "", "UserInfo", "getUserInfo", "VALID_FCHAR", "VALID_PCHAR", "VALID_QCHAR", "VALID_UCHAR", "percentAsciiEncode", "char", "percentEncode", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "byte", "", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Encoding getHost() {
            return Host;
        }

        @NotNull
        public final Encoding getUserInfo() {
            return UserInfo;
        }

        @NotNull
        public final Encoding getPath() {
            return Path;
        }

        @NotNull
        public final Encoding getQuery() {
            return Query;
        }

        @NotNull
        public final Encoding getFragment() {
            return Fragment;
        }

        @NotNull
        public final Encoding getFormUrl() {
            return FormUrl;
        }

        @NotNull
        public final Encoding getSmithyLabel() {
            return SmithyLabel;
        }

        @NotNull
        public final Encoding getSigV4() {
            return SigV4;
        }

        private final String percentAsciiEncode(char c) {
            StringBuilder stringBuilder;
            StringBuilder $this$percentAsciiEncode_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int value = c & 0xFF;
            $this$percentAsciiEncode_u24lambda_u240.append('%');
            $this$percentAsciiEncode_u24lambda_u240.append(PercentEncoding.UPPER_HEX.charAt(value >> 4));
            $this$percentAsciiEncode_u24lambda_u240.append(PercentEncoding.UPPER_HEX.charAt(value & 0xF));
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void percentEncode(StringBuilder $this$percentEncode, byte by) {
            int value = by & 0xFF;
            $this$percentEncode.append('%');
            $this$percentEncode.append(PercentEncoding.UPPER_HEX.charAt(value >> 4));
            $this$percentEncode.append(PercentEncoding.UPPER_HEX.charAt(value & 0xF));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

