/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.Logging;
import com.amazonaws.services.imagebuilder.model.transform.InfrastructureConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfrastructureConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String description;
    private List<String> instanceTypes;
    private String instanceProfileName;
    private List<String> securityGroupIds;
    private String subnetId;
    private Logging logging;
    private String keyPair;
    private Boolean terminateInstanceOnFailure;
    private String snsTopicArn;
    private String dateCreated;
    private String dateUpdated;
    private Map<String, String> resourceTags;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public InfrastructureConfiguration withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InfrastructureConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public InfrastructureConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getInstanceTypes() {
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new ArrayList<String>(instanceTypes);
    }

    public InfrastructureConfiguration withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add(ele);
        }
        return this;
    }

    public InfrastructureConfiguration withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public void setInstanceProfileName(String instanceProfileName) {
        this.instanceProfileName = instanceProfileName;
    }

    public String getInstanceProfileName() {
        return this.instanceProfileName;
    }

    public InfrastructureConfiguration withInstanceProfileName(String instanceProfileName) {
        this.setInstanceProfileName(instanceProfileName);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public InfrastructureConfiguration withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public InfrastructureConfiguration withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public InfrastructureConfiguration withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public InfrastructureConfiguration withLogging(Logging logging) {
        this.setLogging(logging);
        return this;
    }

    public void setKeyPair(String keyPair) {
        this.keyPair = keyPair;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public InfrastructureConfiguration withKeyPair(String keyPair) {
        this.setKeyPair(keyPair);
        return this;
    }

    public void setTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
        this.terminateInstanceOnFailure = terminateInstanceOnFailure;
    }

    public Boolean getTerminateInstanceOnFailure() {
        return this.terminateInstanceOnFailure;
    }

    public InfrastructureConfiguration withTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
        this.setTerminateInstanceOnFailure(terminateInstanceOnFailure);
        return this;
    }

    public Boolean isTerminateInstanceOnFailure() {
        return this.terminateInstanceOnFailure;
    }

    public void setSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
    }

    public String getSnsTopicArn() {
        return this.snsTopicArn;
    }

    public InfrastructureConfiguration withSnsTopicArn(String snsTopicArn) {
        this.setSnsTopicArn(snsTopicArn);
        return this;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public InfrastructureConfiguration withDateCreated(String dateCreated) {
        this.setDateCreated(dateCreated);
        return this;
    }

    public void setDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public String getDateUpdated() {
        return this.dateUpdated;
    }

    public InfrastructureConfiguration withDateUpdated(String dateUpdated) {
        this.setDateUpdated(dateUpdated);
        return this;
    }

    public Map<String, String> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
    }

    public InfrastructureConfiguration withResourceTags(Map<String, String> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public InfrastructureConfiguration addResourceTagsEntry(String key, String value) {
        if (null == this.resourceTags) {
            this.resourceTags = new HashMap<String, String>();
        }
        if (this.resourceTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resourceTags.put(key, value);
        return this;
    }

    public InfrastructureConfiguration clearResourceTagsEntries() {
        this.resourceTags = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public InfrastructureConfiguration withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public InfrastructureConfiguration addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public InfrastructureConfiguration clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getInstanceProfileName() != null) {
            sb.append("InstanceProfileName: ").append(this.getInstanceProfileName()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getLogging() != null) {
            sb.append("Logging: ").append(this.getLogging()).append(",");
        }
        if (this.getKeyPair() != null) {
            sb.append("KeyPair: ").append(this.getKeyPair()).append(",");
        }
        if (this.getTerminateInstanceOnFailure() != null) {
            sb.append("TerminateInstanceOnFailure: ").append(this.getTerminateInstanceOnFailure()).append(",");
        }
        if (this.getSnsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.getSnsTopicArn()).append(",");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: ").append(this.getDateCreated()).append(",");
        }
        if (this.getDateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.getDateUpdated()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfrastructureConfiguration)) {
            return false;
        }
        InfrastructureConfiguration other = (InfrastructureConfiguration)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getInstanceProfileName() == null ^ this.getInstanceProfileName() == null) {
            return false;
        }
        if (other.getInstanceProfileName() != null && !other.getInstanceProfileName().equals(this.getInstanceProfileName())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        if (other.getLogging() != null && !other.getLogging().equals(this.getLogging())) {
            return false;
        }
        if (other.getKeyPair() == null ^ this.getKeyPair() == null) {
            return false;
        }
        if (other.getKeyPair() != null && !other.getKeyPair().equals(this.getKeyPair())) {
            return false;
        }
        if (other.getTerminateInstanceOnFailure() == null ^ this.getTerminateInstanceOnFailure() == null) {
            return false;
        }
        if (other.getTerminateInstanceOnFailure() != null && !other.getTerminateInstanceOnFailure().equals(this.getTerminateInstanceOnFailure())) {
            return false;
        }
        if (other.getSnsTopicArn() == null ^ this.getSnsTopicArn() == null) {
            return false;
        }
        if (other.getSnsTopicArn() != null && !other.getSnsTopicArn().equals(this.getSnsTopicArn())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getDateUpdated() == null ^ this.getDateUpdated() == null) {
            return false;
        }
        if (other.getDateUpdated() != null && !other.getDateUpdated().equals(this.getDateUpdated())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        if (other.getResourceTags() != null && !other.getResourceTags().equals(this.getResourceTags())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileName() == null ? 0 : this.getInstanceProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPair() == null ? 0 : this.getKeyPair().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateInstanceOnFailure() == null ? 0 : this.getTerminateInstanceOnFailure().hashCode());
        hashCode = 31 * hashCode + (this.getSnsTopicArn() == null ? 0 : this.getSnsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDateUpdated() == null ? 0 : this.getDateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public InfrastructureConfiguration clone() {
        try {
            return (InfrastructureConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InfrastructureConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

