/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CreateActivationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateActivationRequestMarshaller
implements Marshaller<Request<CreateActivationRequest>, CreateActivationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateActivationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateActivationRequest> marshall(CreateActivationRequest createActivationRequest) {
        if (createActivationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createActivationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreateActivation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createActivationRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createActivationRequest.getDescription());
            }
            if (createActivationRequest.getDefaultInstanceName() != null) {
                jsonGenerator.writeFieldName("DefaultInstanceName").writeValue(createActivationRequest.getDefaultInstanceName());
            }
            if (createActivationRequest.getIamRole() != null) {
                jsonGenerator.writeFieldName("IamRole").writeValue(createActivationRequest.getIamRole());
            }
            if (createActivationRequest.getRegistrationLimit() != null) {
                jsonGenerator.writeFieldName("RegistrationLimit").writeValue(createActivationRequest.getRegistrationLimit().intValue());
            }
            if (createActivationRequest.getExpirationDate() != null) {
                jsonGenerator.writeFieldName("ExpirationDate").writeValue(createActivationRequest.getExpirationDate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

