/*
 * Decompiled with CFR 0.152.
 */
package datadog.common.exec;

import datadog.common.exec.DaemonThreadFactory;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.concurrent.Delayed;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CommonTaskExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommonTaskExecutor.class);
    public static final CommonTaskExecutor INSTANCE = new CommonTaskExecutor();
    private static final long SHUTDOWN_WAIT_SECONDS = 5L;

    private CommonTaskExecutor() {
        super(1, DaemonThreadFactory.TASK_SCHEDULER);
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownCallback(this));
        }
        catch (IllegalStateException ex) {
            log.debug("Error adding shutdown hook", ex);
        }
    }

    public void initialize() {
    }

    public <T> ScheduledFuture<?> scheduleAtFixedRate(Task<T> task, T target, long initialDelay, long period, TimeUnit unit, String name) {
        if (INSTANCE.isShutdown()) {
            log.warn("Periodic task scheduler is shutdown. Will not run: {}", (Object)name);
        } else {
            try {
                PeriodicTask<T> periodicTask = new PeriodicTask<T>(task, target);
                ScheduledFuture<?> future = super.scheduleAtFixedRate(periodicTask, initialDelay, period, unit);
                periodicTask.setFuture(future);
                return future;
            }
            catch (RejectedExecutionException e) {
                log.warn("Periodic task rejected. Will not run: {}", (Object)name);
            }
        }
        return new UnscheduledFuture(name);
    }

    private static class UnscheduledFuture
    implements ScheduledFuture<Object> {
        private static final Logger log = LoggerFactory.getLogger(UnscheduledFuture.class);
        private final String name;

        public UnscheduledFuture(String name) {
            this.name = name;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            log.debug("Cancelling unscheduled future for: {}", (Object)this.name);
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) {
            return null;
        }
    }

    private static class PeriodicTask<T>
    implements Runnable {
        private final WeakReference<T> target;
        private final Task<T> task;
        private volatile ScheduledFuture<?> future = null;

        public PeriodicTask(Task<T> task, T target) {
            this.target = new WeakReference<T>(target);
            this.task = task;
        }

        @Override
        public void run() {
            Object t = this.target.get();
            if (t != null) {
                this.task.run(t);
            } else if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }
    }

    public static interface Task<T> {
        public void run(T var1);
    }

    private static final class ShutdownCallback
    extends Thread {
        private final ScheduledExecutorService executorService;

        private ShutdownCallback(ScheduledExecutorService executorService) {
            super("dd-exec-shutdown-hook");
            this.executorService = executorService;
        }

        @Override
        public void run() {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
    }
}

