/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.cache;

import datadog.trace.api.IntFunction;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class RadixTreeCache<T> {
    private static final IntFunction<Integer> AUTOBOX = new IntFunction<Integer>(){

        @Override
        public Integer apply(int value) {
            return value;
        }
    };
    public static final RadixTreeCache<Integer> HTTP_STATUSES = new RadixTreeCache<Integer>(16, 32, AUTOBOX, 200, 201, 301, 307, 400, 401, 403, 404, 500, 502, 503);
    public static final RadixTreeCache<Integer> PORTS = new RadixTreeCache<Integer>(256, 256, AUTOBOX, 80, 443, 8080);
    private final int level1;
    private final int level2;
    private final int shift;
    private final int mask;
    private final AtomicReferenceArray<Object[]> tree;
    private final IntFunction<T> mapper;

    public RadixTreeCache(int level1, int level2, IntFunction<T> mapper, int ... commonValues) {
        this.tree = new AtomicReferenceArray(level1);
        this.mapper = mapper;
        this.level1 = level1;
        this.level2 = level2;
        this.mask = level2 - 1;
        this.shift = Integer.bitCount(this.mask);
        for (int commonValue : commonValues) {
            this.get(commonValue);
        }
    }

    public T get(int primitive) {
        int prefix = primitive >>> this.shift;
        if (prefix >= this.level1) {
            return this.mapper.apply(primitive);
        }
        return this.computeIfAbsent(prefix, primitive);
    }

    private T computeIfAbsent(int prefix, int primitive) {
        int suffix;
        Object cached;
        Object[] page = this.tree.get(prefix);
        if (null == page && !this.tree.compareAndSet(prefix, null, page = new Object[this.level2])) {
            page = this.tree.get(prefix);
        }
        if ((cached = page[suffix = primitive & this.mask]) == null) {
            cached = page[suffix] = this.mapper.apply(primitive);
        }
        return (T)cached;
    }
}

