/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class UTF8BytesString
implements CharSequence {
    private static final Allocator ALLOCATOR = new Allocator();
    private final String string;
    private final byte[] utf8Bytes;
    private final int offset;
    private final int length;

    public static UTF8BytesString createConstant(CharSequence string) {
        return UTF8BytesString.create(string, true);
    }

    public static UTF8BytesString create(CharSequence chars) {
        return UTF8BytesString.create(chars, false);
    }

    private static UTF8BytesString create(CharSequence sequence, boolean constant) {
        if (null == sequence) {
            return null;
        }
        if (sequence instanceof UTF8BytesString) {
            return (UTF8BytesString)sequence;
        }
        return new UTF8BytesString(sequence, constant);
    }

    private UTF8BytesString(CharSequence chars, boolean constant) {
        Allocator.Allocation allocation;
        this.string = chars instanceof String ? new String((String)chars) : String.valueOf(chars);
        byte[] utf8Bytes = this.string.getBytes(StandardCharsets.UTF_8);
        this.length = utf8Bytes.length;
        if (constant && null != (allocation = ALLOCATOR.allocate(utf8Bytes))) {
            this.offset = allocation.position;
            this.utf8Bytes = allocation.page;
            return;
        }
        this.offset = 0;
        this.utf8Bytes = utf8Bytes;
    }

    public void transferTo(ByteBuffer buffer) {
        buffer.put(this.utf8Bytes, this.offset, this.length);
    }

    public int encodedLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        String that = null;
        if (o instanceof UTF8BytesString) {
            that = ((UTF8BytesString)o).string;
        }
        return this.string.equals(that);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.subSequence(start, end);
    }

    private static class Allocator {
        private static final int PAGE_SIZE = 8192;
        private final List<byte[]> pages = new ArrayList<byte[]>();
        private int currentPage = -1;
        int currentPosition = 0;

        Allocator() {
        }

        synchronized Allocation allocate(byte[] utf8) {
            byte[] page = this.getPageWithCapacity(utf8.length);
            if (null == page) {
                return null;
            }
            System.arraycopy(utf8, 0, page, this.currentPosition, utf8.length);
            this.currentPosition += utf8.length;
            return new Allocation(this.currentPosition - utf8.length, page);
        }

        private byte[] getPageWithCapacity(int length) {
            if (length >= 8192) {
                return null;
            }
            if (this.currentPage < 0) {
                this.newPage();
            } else if (this.currentPosition + length >= 8192) {
                this.newPage();
            }
            return this.pages.get(this.currentPage);
        }

        private void newPage() {
            this.pages.add(new byte[8192]);
            ++this.currentPage;
            this.currentPosition = 0;
        }

        private static final class Allocation {
            final int position;
            final byte[] page;

            private Allocation(int position, byte[] page) {
                this.position = position;
                this.page = page;
            }
        }
    }
}

