/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux.proc;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.hardware.Processor;
import oshi.software.os.linux.Libc;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class CentralProcessor
implements Processor {
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private static boolean sunMXBean;
    private static long tickTime;
    private static long[] prevTicks;
    private static long[] curTicks;
    private long procTickTime = System.currentTimeMillis();
    private long[] prevProcTicks = new long[4];
    private long[] curProcTicks = new long[4];
    private static int numCPU;
    private static long[][] allProcessorTicks;
    private static long allProcTickTime;
    private int processorNumber;
    private String cpuVendor;
    private String cpuName;
    private String cpuIdentifier = null;
    private String cpuStepping;
    private String cpuModel;
    private String cpuFamily;
    private Long cpuVendorFreq = null;
    private Boolean cpu64;

    public CentralProcessor(int procNo) {
        if (procNo >= numCPU) {
            throw new IllegalArgumentException("Processor number (" + procNo + ") must be less than the number of CPUs: " + numCPU);
        }
        this.processorNumber = procNo;
        CentralProcessor.updateProcessorTicks();
        System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
    }

    @Override
    public int getProcessorNumber() {
        return this.processorNumber;
    }

    @Override
    public String getVendor() {
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ");
            sb.append(this.getFamily());
            sb.append(" Model ");
            sb.append(this.getModel());
            sb.append(" Stepping ");
            sb.append(this.getStepping());
            this.cpuIdentifier = sb.toString();
        }
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        return this.cpu64;
    }

    @Override
    public void setCpu64(boolean cpu64) {
        this.cpu64 = cpu64;
    }

    @Override
    public String getStepping() {
        return this.cpuStepping;
    }

    @Override
    public void setStepping(String stepping) {
        this.cpuStepping = stepping;
    }

    @Override
    public String getModel() {
        return this.cpuModel;
    }

    @Override
    public void setModel(String model) {
        this.cpuModel = model;
    }

    @Override
    public String getFamily() {
        return this.cpuFamily;
    }

    @Override
    public void setFamily(String family) {
        this.cpuFamily = family;
    }

    @Override
    @Deprecated
    public float getLoad() {
        return (float)this.getSystemCpuLoadBetweenTicks() * 100.0f;
    }

    @Override
    public double getSystemCpuLoadBetweenTicks() {
        boolean update;
        long now = System.currentTimeMillis();
        boolean bl = update = now - tickTime > 950L;
        if (update) {
            CentralProcessor.updateSystemTicks();
            tickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < curTicks.length; ++i) {
            total += curTicks[i] - prevTicks[i];
        }
        long idle = curTicks[3] - prevTicks[3];
        if (update) {
            System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        }
        if (total > 0L && idle >= 0L) {
            return (double)(total - idle) / (double)total;
        }
        return 0.0;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        CentralProcessor.updateSystemTicks();
        long[] ticks = new long[curTicks.length];
        System.arraycopy(curTicks, 0, ticks, 0, curTicks.length);
        return ticks;
    }

    private static void updateSystemTicks() {
        String tickStr = "";
        try {
            List<String> procStat = FileUtil.readFile("/proc/stat");
            if (!procStat.isEmpty()) {
                tickStr = procStat.get(0);
            }
        }
        catch (IOException e) {
            System.err.println("Problem with: /proc/stat");
            System.err.println(e.getMessage());
            return;
        }
        String[] tickArr = tickStr.split("\\s+");
        if (tickArr.length < 5) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            CentralProcessor.curTicks[i] = Long.parseLong(tickArr[i + 1]);
        }
    }

    @Override
    public double getSystemCpuLoad() {
        if (sunMXBean) {
            return ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return OS_MXBEAN.getSystemLoadAverage();
    }

    @Override
    public double getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        if (now - this.procTickTime > 950L) {
            CentralProcessor.updateProcessorTicks();
            System.arraycopy(this.curProcTicks, 0, this.prevProcTicks, 0, this.curProcTicks.length);
            System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
            this.procTickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < this.curProcTicks.length; ++i) {
            total += this.curProcTicks[i] - this.prevProcTicks[i];
        }
        long idle = this.curProcTicks[3] - this.prevProcTicks[3];
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public long[] getProcessorCpuLoadTicks() {
        CentralProcessor.updateProcessorTicks();
        return allProcessorTicks[this.processorNumber];
    }

    private static void updateProcessorTicks() {
        long now = System.currentTimeMillis();
        if (now - allProcTickTime < 100L) {
            return;
        }
        try {
            int cpu = 0;
            List<String> procStat = FileUtil.readFile("/proc/stat");
            for (String stat : procStat) {
                if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
                String[] tickArr = stat.split("\\s+");
                if (tickArr.length >= 5) {
                    for (int i = 0; i < 4; ++i) {
                        CentralProcessor.allProcessorTicks[cpu][i] = Long.parseLong(tickArr[i + 1]);
                    }
                    if (++cpu < numCPU) continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("Problem with: /proc/stat");
            System.err.println(e.getMessage());
        }
        allProcTickTime = now;
    }

    @Override
    public long getSystemUptime() {
        Libc.Sysinfo info = new Libc.Sysinfo();
        if (0 != Libc.INSTANCE.sysinfo(info)) {
            throw new LastErrorException("Error code: " + Native.getLastError());
        }
        return info.uptime.longValue();
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            sunMXBean = true;
        }
        catch (ClassNotFoundException e) {
            sunMXBean = false;
        }
        tickTime = System.currentTimeMillis();
        prevTicks = new long[4];
        curTicks = new long[4];
        CentralProcessor.updateSystemTicks();
        System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        numCPU = 0;
        try {
            List<String> procCpu = FileUtil.readFile("/proc/cpuinfo");
            for (String cpu : procCpu) {
                if (!cpu.startsWith("processor")) continue;
                ++numCPU;
            }
        }
        catch (IOException e) {
            System.err.println("Problem with: /proc/cpuinfo");
            System.err.println(e.getMessage());
        }
        if (numCPU < 1) {
            numCPU = 1;
        }
        allProcessorTicks = new long[numCPU][4];
        allProcTickTime = 0L;
    }
}

