/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux.proc;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.io.IOException;
import java.util.List;
import oshi.hardware.Memory;
import oshi.software.os.linux.Libc;
import oshi.util.FileUtil;

public class GlobalMemory
implements Memory {
    private long totalMemory = 0L;

    @Override
    public long getAvailable() {
        long availableMemory = 0L;
        List<String> memInfo = null;
        try {
            memInfo = FileUtil.readFile("/proc/meminfo");
        }
        catch (IOException e) {
            System.err.println("Problem with: /proc/meminfo");
            System.err.println(e.getMessage());
            return availableMemory;
        }
        for (String checkLine : memInfo) {
            String[] memorySplit;
            if (checkLine.startsWith("MemAvailable:")) {
                memorySplit = checkLine.split("\\s+");
                availableMemory = this.parseMeminfo(memorySplit);
                break;
            }
            if (checkLine.startsWith("MemFree:")) {
                memorySplit = checkLine.split("\\s+");
                availableMemory += this.parseMeminfo(memorySplit);
                continue;
            }
            if (checkLine.startsWith("Active(file):")) {
                memorySplit = checkLine.split("\\s+");
                availableMemory += this.parseMeminfo(memorySplit);
                continue;
            }
            if (checkLine.startsWith("Inactive(file):")) {
                memorySplit = checkLine.split("\\s+");
                availableMemory += this.parseMeminfo(memorySplit);
                continue;
            }
            if (!checkLine.startsWith("SReclaimable:")) continue;
            memorySplit = checkLine.split("\\s+");
            availableMemory += this.parseMeminfo(memorySplit);
        }
        return availableMemory;
    }

    @Override
    public long getTotal() {
        if (this.totalMemory == 0L) {
            Libc.Sysinfo info = new Libc.Sysinfo();
            if (0 != Libc.INSTANCE.sysinfo(info)) {
                throw new LastErrorException("Error code: " + Native.getLastError());
            }
            this.totalMemory = info.totalram.longValue() * (long)info.mem_unit;
        }
        return this.totalMemory;
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = new Long(memorySplit[1]);
        if (memorySplit.length > 2 && memorySplit[2].equals("kB")) {
            memory *= 1024L;
        }
        return memory;
    }
}

