/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux.proc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oshi.hardware.PowerSource;
import oshi.util.FileUtil;

public class LinuxPowerSource
implements PowerSource {
    private static final String PS_PATH = "/sys/class/power_supply/";
    private String name;
    private double remainingCapacity;
    private double timeRemaining;

    public LinuxPowerSource(String name, double remainingCapacity, double timeRemaining) {
        this.name = name;
        this.remainingCapacity = remainingCapacity;
        this.timeRemaining = timeRemaining;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRemainingCapacity() {
        return this.remainingCapacity;
    }

    @Override
    public double getTimeRemaining() {
        return this.timeRemaining;
    }

    public static PowerSource[] getPowerSources() {
        File f = new File(PS_PATH);
        String[] psNames = f.list();
        if (psNames == null) {
            psNames = new String[]{};
        }
        ArrayList<LinuxPowerSource> psList = new ArrayList<LinuxPowerSource>(psNames.length);
        for (String psName : psNames) {
            List<String> psInfo;
            if (psName.startsWith("ADP")) continue;
            try {
                psInfo = FileUtil.readFile(PS_PATH + psName + "/uevent");
            }
            catch (IOException e) {
                continue;
            }
            boolean isPresent = false;
            boolean isCharging = false;
            String name = "Unknown";
            int energyNow = 0;
            int energyFull = 1;
            int powerNow = 1;
            for (String checkLine : psInfo) {
                String[] psSplit;
                if (checkLine.startsWith("POWER_SUPPLY_PRESENT")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length > 1) {
                        boolean bl = isPresent = Integer.parseInt(psSplit[1]) > 0;
                    }
                    if (isPresent) continue;
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_NAME")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    name = psSplit[1];
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_NOW") || checkLine.startsWith("POWER_SUPPLY_CHARGE_NOW")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    energyNow = Integer.parseInt(psSplit[1]);
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_FULL") || checkLine.startsWith("POWER_SUPPLY_CHARGE_FULL")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    energyFull = Integer.parseInt(psSplit[1]);
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_STATUS")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1 || !psSplit[1].equals("Charging")) continue;
                    isCharging = true;
                    continue;
                }
                if (!checkLine.startsWith("POWER_SUPPLY_POWER_NOW") && !checkLine.startsWith("POWER_SUPPLY_CURRENT_NOW")) continue;
                psSplit = checkLine.split("=");
                if (psSplit.length > 1) {
                    powerNow = Integer.parseInt(psSplit[1]);
                }
                if (powerNow > 0) continue;
                isCharging = true;
            }
            psList.add(new LinuxPowerSource(name, (double)energyNow / (double)energyFull, isCharging ? -2.0 : 3600.0 * (double)energyNow / (double)powerNow));
        }
        return psList.toArray(new LinuxPowerSource[psList.size()]);
    }
}

