/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac.local;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import oshi.hardware.PowerSource;
import oshi.software.os.mac.local.CoreFoundation;
import oshi.software.os.mac.local.IOKit;

public class MacPowerSource
implements PowerSource {
    private String name;
    private double remainingCapacity;
    private double timeRemaining;

    public MacPowerSource(String name, double remainingCapacity, double timeRemaining) {
        this.name = name;
        this.remainingCapacity = remainingCapacity;
        this.timeRemaining = timeRemaining;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRemainingCapacity() {
        return this.remainingCapacity;
    }

    @Override
    public double getTimeRemaining() {
        return this.timeRemaining;
    }

    public static PowerSource[] getPowerSources() {
        CoreFoundation.CFTypeRef powerSourcesInfo = IOKit.INSTANCE.IOPSCopyPowerSourcesInfo();
        CoreFoundation.CFArrayRef powerSourcesList = IOKit.INSTANCE.IOPSCopyPowerSourcesList(powerSourcesInfo);
        int powerSourcesCount = CoreFoundation.INSTANCE.CFArrayGetCount(powerSourcesList);
        double timeRemaining = IOKit.INSTANCE.IOPSGetTimeRemainingEstimate();
        ArrayList<MacPowerSource> psList = new ArrayList<MacPowerSource>(powerSourcesCount);
        for (int ps = 0; ps < powerSourcesCount; ++ps) {
            IntByReference maxCapacity;
            CoreFoundation.CFTypeRef powerSource = CoreFoundation.INSTANCE.CFArrayGetValueAtIndex(powerSourcesList, ps);
            CoreFoundation.CFDictionaryRef dictionary = IOKit.INSTANCE.IOPSGetPowerSourceDescription(powerSourcesInfo, powerSource);
            boolean isPresent = false;
            Pointer isPresentRef = CoreFoundation.INSTANCE.CFDictionaryGetValue(dictionary, IOKit.IOPS_IS_PRESENT_KEY);
            if (isPresentRef != null) {
                isPresent = CoreFoundation.INSTANCE.CFBooleanGetValue(isPresentRef);
            }
            if (!isPresent) continue;
            Pointer name = CoreFoundation.INSTANCE.CFDictionaryGetValue(dictionary, IOKit.IOPS_NAME_KEY);
            long length = CoreFoundation.INSTANCE.CFStringGetLength(name);
            long maxSize = CoreFoundation.INSTANCE.CFStringGetMaximumSizeForEncoding(length, 0x8000100);
            Memory nameBuf = new Memory(maxSize);
            CoreFoundation.INSTANCE.CFStringGetCString(name, (Pointer)nameBuf, maxSize, 0x8000100);
            IntByReference currentCapacity = new IntByReference();
            if (!CoreFoundation.INSTANCE.CFDictionaryGetValueIfPresent(dictionary, IOKit.IOPS_CURRENT_CAPACITY_KEY, (PointerType)currentCapacity)) {
                currentCapacity = new IntByReference(0);
            }
            if (!CoreFoundation.INSTANCE.CFDictionaryGetValueIfPresent(dictionary, IOKit.IOPS_MAX_CAPACITY_KEY, (PointerType)(maxCapacity = new IntByReference()))) {
                maxCapacity = new IntByReference(1);
            }
            psList.add(new MacPowerSource(nameBuf != null ? nameBuf.getString(0L) : "Unknown", (double)currentCapacity.getValue() / (double)maxCapacity.getValue(), timeRemaining));
        }
        CoreFoundation.INSTANCE.CFRelease(powerSourcesInfo);
        return psList.toArray(new MacPowerSource[psList.size()]);
    }
}

