/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TypeSafeTemplate;
import com.github.jknack.handlebars.internal.FastStringWriter;
import com.github.jknack.handlebars.internal.Files;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;

abstract class BaseTemplate
implements Template {
    protected int line;
    protected int column;
    protected String filename;
    private final Object jsLock = new Object();
    private String javaScript;
    private static final String HBS_FILE = "/handlebars-1.0.0.js";
    private ScriptableObject sharedScope;

    BaseTemplate() {
    }

    @Override
    public final String apply(Object context) throws IOException {
        return this.apply(BaseTemplate.wrap(context));
    }

    @Override
    public final void apply(Object context, Writer writer) throws IOException {
        this.apply(BaseTemplate.wrap(context), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(Context context) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        try {
            this.apply(context, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void apply(Context context, Writer writer) throws IOException {
        Validate.notNull((Object)writer, (String)"A writer is required.", (Object[])new Object[0]);
        Context wrapped = BaseTemplate.wrap(context);
        try {
            this.merge(wrapped, writer);
        }
        catch (HandlebarsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String evidence = this.toString();
            String reason = ex.toString();
            String message = this.filename + ":" + this.line + ":" + this.column + ": " + reason + "\n";
            message = message + "    " + StringUtils.join((Object[])StringUtils.split((String)evidence, (String)"\n"), (String)"\n    ");
            HandlebarsError error = new HandlebarsError(this.filename, this.line, this.column, reason, evidence, message);
            HandlebarsException hex = new HandlebarsException(error, (Throwable)ex);
            hex.setStackTrace(ex.getStackTrace());
            throw hex;
        }
        finally {
            if (wrapped != context) {
                wrapped.destroy();
            }
        }
    }

    private static Context wrap(Object candidate) {
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        return Context.newContext(candidate);
    }

    protected abstract void merge(Context var1, Writer var2) throws IOException;

    public String toString() {
        return this.text();
    }

    public BaseTemplate filename(String filename) {
        this.filename = filename;
        return this;
    }

    public BaseTemplate position(int line, int column) {
        this.line = line;
        this.column = column;
        return this;
    }

    @Override
    public <T, S extends TypeSafeTemplate<T>> S as(Class<S> rootType) {
        Validate.notNull(rootType, (String)"The rootType can't be null.", (Object[])new Object[0]);
        Validate.isTrue((boolean)rootType.isInterface(), (String)"Not an interface: %s", (Object[])new Object[]{rootType.getName()});
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(rootType, this);
        return (S)template;
    }

    @Override
    public <T> TypeSafeTemplate<T> as() {
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(TypeSafeTemplate.class, this);
        return template;
    }

    private static Object newTypeSafeTemplate(Class<?> rootType, final Template template) {
        return Proxy.newProxyInstance(template.getClass().getClassLoader(), new Class[]{rootType}, new InvocationHandler(){
            private Map<String, Object> attributes = new HashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws IOException {
                String methodName = method.getName();
                if ("apply".equals(methodName)) {
                    Context context = Context.newBuilder(args[0]).combine(this.attributes).build();
                    this.attributes.clear();
                    if (args.length == 2) {
                        template.apply(context, (Writer)args[1]);
                        return null;
                    }
                    return template.apply(context);
                }
                if (Modifier.isPublic(method.getModifiers()) && methodName.startsWith("set")) {
                    String attrName = StringUtils.uncapitalize((String)methodName.substring("set".length()));
                    if (args != null && args.length == 1 && attrName.length() > 0) {
                        this.attributes.put(attrName, args[0]);
                        if (TypeSafeTemplate.class.isAssignableFrom(method.getReturnType())) {
                            return proxy;
                        }
                        return null;
                    }
                }
                String message = String.format("No handler method for: '%s(%s)', expected method signature is: 'setXxx(value)'", methodName, args == null ? "" : StringUtils.join((Object[])args, (String)", "));
                throw new UnsupportedOperationException(message);
            }
        });
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        Validate.isTrue((tagType.length > 0 ? 1 : 0) != 0, (String)"At least one tag type is required.", (Object[])new Object[0]);
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        for (TagType tt : tagType) {
            this.collect(tagNames, tt);
        }
        return new ArrayList<String>(tagNames);
    }

    protected void collect(Collection<String> result, TagType tagType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJavaScript() throws IOException {
        Object object = this.jsLock;
        synchronized (object) {
            if (this.javaScript == null) {
                org.mozilla.javascript.Context ctx = null;
                try {
                    ctx = this.newContext();
                    Scriptable scope = this.newScope(ctx);
                    scope.put("template", scope, (Object)this.text());
                    String js = "Handlebars.precompile(template);";
                    Object precompiled = ctx.evaluateString(scope, js, this.filename, 1, null);
                    this.javaScript = (String)precompiled;
                }
                finally {
                    if (ctx != null) {
                        org.mozilla.javascript.Context.exit();
                    }
                }
            }
            return this.javaScript;
        }
    }

    private org.mozilla.javascript.Context newContext() {
        org.mozilla.javascript.Context ctx = org.mozilla.javascript.Context.enter();
        ctx.setOptimizationLevel(-1);
        ctx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        ctx.setLanguageVersion(180);
        return ctx;
    }

    private Scriptable newScope(org.mozilla.javascript.Context ctx) {
        Scriptable sharedScope = this.sharedScope(ctx);
        Scriptable scope = ctx.newObject(sharedScope);
        scope.setParentScope(null);
        scope.setPrototype(sharedScope);
        return scope;
    }

    private Scriptable sharedScope(org.mozilla.javascript.Context ctx) {
        if (this.sharedScope == null) {
            this.sharedScope = ctx.initStandardObjects();
            ctx.evaluateString((Scriptable)this.sharedScope, this.handlebarsScript(HBS_FILE), HBS_FILE, 1, null);
        }
        return this.sharedScope;
    }

    private String handlebarsScript(String location) {
        try {
            return Files.read(location);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to read file: " + location, ex);
        }
    }
}

