/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.internal.BaseTemplate;
import java.io.IOException;
import java.io.Writer;

class Text
extends BaseTemplate {
    private char[] text;
    private String escapeChar;

    public Text(Handlebars handlebars, String text, String escapeChar) {
        super(handlebars);
        int length = text.length();
        this.text = new char[length];
        text.getChars(0, length, this.text, 0);
        this.escapeChar = escapeChar;
    }

    public Text(Handlebars handlebars, String text) {
        this(handlebars, text, "");
    }

    @Override
    public String text() {
        return this.escapeChar + new String(this.text);
    }

    public char[] textWithoutEscapeChar() {
        return this.text;
    }

    @Override
    protected void merge(Context scope, Writer writer) throws IOException {
        writer.write(this.text);
    }

    public Text append(char[] text) {
        int length = this.text.length + text.length;
        char[] ntext = new char[length];
        System.arraycopy(this.text, 0, ntext, 0, this.text.length);
        System.arraycopy(text, 0, ntext, this.text.length, text.length);
        this.text = ntext;
        return this;
    }
}

