/*
 * Decompiled with CFR 0.152.
 */
package com.github.msarhan.ummalqura.calendar;

import com.github.msarhan.ummalqura.calendar.DateTimeException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class HijrahChronology
implements Serializable {
    private static final long serialVersionUID = 3127340209035924785L;
    public static final HijrahChronology INSTANCE;
    private volatile transient boolean initComplete;
    private transient int[] hijrahEpochMonthStartDays;
    private transient int minEpochDay;
    private transient int maxEpochDay;
    private transient int hijrahStartEpochMonth;
    private transient int minMonthLength;
    private transient int maxMonthLength;
    private transient int minYearLength;
    private transient int maxYearLength;
    private static final String PROP_PREFIX = "calendar.hijrah.";
    private static final String PROP_TYPE_SUFFIX = ".type";
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VERSION = "version";
    private static final String KEY_ISO_START = "iso-start";
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;

    private HijrahChronology() throws DateTimeException {
    }

    private void checkCalendarInit() {
        if (!this.initComplete) {
            this.loadCalendarData();
            this.initComplete = true;
        }
    }

    public boolean isLeapYear(long prolepticYear) {
        this.checkCalendarInit();
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            return false;
        }
        int len = this.getYearLength((int)prolepticYear);
        return len > 354;
    }

    int checkValidYear(long prolepticYear) {
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            throw new DateTimeException("Invalid Hijrah year: " + prolepticYear);
        }
        return (int)prolepticYear;
    }

    void checkValidDayOfYear(int dayOfYear) {
        if (dayOfYear < 1 || dayOfYear > this.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid Hijrah day of year: " + dayOfYear);
        }
    }

    void checkValidMonth(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid Hijrah month: " + month);
        }
    }

    int[] getHijrahDateInfo(int epochDay) {
        this.checkCalendarInit();
        if (epochDay < this.minEpochDay || epochDay >= this.maxEpochDay) {
            throw new DateTimeException("Hijrah date out of range");
        }
        int epochMonth = this.epochDayToEpochMonth(epochDay);
        int year = this.epochMonthToYear(epochMonth);
        int month = this.epochMonthToMonth(epochMonth);
        int day1 = this.epochMonthToEpochDay(epochMonth);
        int date = epochDay - day1;
        int[] dateInfo = new int[]{year, month, date + 1};
        return dateInfo;
    }

    long getEpochDay(int prolepticYear, int monthOfYear, int dayOfMonth) {
        this.checkCalendarInit();
        this.checkValidMonth(monthOfYear);
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        if (dayOfMonth < 1 || dayOfMonth > this.getMonthLength(prolepticYear, monthOfYear)) {
            throw new DateTimeException("Invalid Hijrah day of month: " + dayOfMonth);
        }
        return this.epochMonthToEpochDay(epochMonth) + (dayOfMonth - 1);
    }

    int getDayOfYear(int prolepticYear, int month) {
        return this.yearMonthToDayOfYear(prolepticYear, month - 1);
    }

    int getMonthLength(int prolepticYear, int monthOfYear) {
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        return this.epochMonthLength(epochMonth);
    }

    int getYearLength(int prolepticYear) {
        return this.yearMonthToDayOfYear(prolepticYear, 12);
    }

    int getMinimumYear() {
        return this.epochMonthToYear(0);
    }

    int getMaximumYear() {
        return this.epochMonthToYear(this.hijrahEpochMonthStartDays.length - 1) - 1;
    }

    int getMaximumMonthLength() {
        return this.maxMonthLength;
    }

    int getMinimumMonthLength() {
        return this.minMonthLength;
    }

    int getMaximumDayOfYear() {
        return this.maxYearLength;
    }

    int getSmallestMaximumDayOfYear() {
        return this.minYearLength;
    }

    private int epochDayToEpochMonth(int epochDay) {
        int ndx = Arrays.binarySearch(this.hijrahEpochMonthStartDays, epochDay);
        if (ndx < 0) {
            ndx = -ndx - 2;
        }
        return ndx;
    }

    private int epochMonthToYear(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) / 12;
    }

    private int yearToEpochMonth(int year) {
        return year * 12 - this.hijrahStartEpochMonth;
    }

    private int epochMonthToMonth(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) % 12;
    }

    private int epochMonthToEpochDay(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth];
    }

    private int yearMonthToDayOfYear(int prolepticYear, int month) {
        int epochMonthFirst = this.yearToEpochMonth(prolepticYear);
        return this.epochMonthToEpochDay(epochMonthFirst + month) - this.epochMonthToEpochDay(epochMonthFirst);
    }

    private int epochMonthLength(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth + 1] - this.hijrahEpochMonthStartDays[epochMonth];
    }

    private static Properties readConfigProperties() throws Exception {
        Properties props = new Properties();
        try (InputStream is = HijrahChronology.class.getResourceAsStream("/com/github/msarhan/ummalqura/calendar/hijrah-config.properties");){
            props.load(is);
        }
        return props;
    }

    private void loadCalendarData() {
        try {
            Properties props = HijrahChronology.readConfigProperties();
            HashMap<Integer, int[]> years = new HashMap<Integer, int[]>();
            int minYear = Integer.MAX_VALUE;
            int maxYear = Integer.MIN_VALUE;
            String version = null;
            int isoStart = 0;
            block15: for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key;
                switch (key = (String)entry.getKey()) {
                    case "version": {
                        version = (String)entry.getValue();
                        continue block15;
                    }
                    case "iso-start": {
                        int[] ymd = this.parseYMD((String)entry.getValue());
                        isoStart = (int)this.toIsoEpochDay(ymd[0], ymd[1], ymd[2]);
                        continue block15;
                    }
                    case "type": 
                    case "id": {
                        continue block15;
                    }
                }
                try {
                    int year = Integer.parseInt(key);
                    int[] months = this.parseMonths((String)entry.getValue());
                    years.put(year, months);
                    maxYear = Math.max(maxYear, year);
                    minYear = Math.min(minYear, year);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("bad key: " + key);
                }
            }
            if (version == null || version.isEmpty()) {
                throw new IllegalArgumentException("Configuration does not contain a version");
            }
            if (isoStart == 0) {
                throw new IllegalArgumentException("Configuration does not contain a ISO start date");
            }
            this.hijrahStartEpochMonth = minYear * 12;
            this.minEpochDay = isoStart;
            this.hijrahEpochMonthStartDays = this.createEpochMonths(this.minEpochDay, minYear, maxYear, years);
            this.maxEpochDay = this.hijrahEpochMonthStartDays[this.hijrahEpochMonthStartDays.length - 1];
            for (int year = minYear; year < maxYear; ++year) {
                int length = this.getYearLength(year);
                this.minYearLength = Math.min(this.minYearLength, length);
                this.maxYearLength = Math.max(this.maxYearLength, length);
            }
        }
        catch (Exception ex) {
            throw new DateTimeException("Unable to initialize HijrahCalendar", ex);
        }
    }

    private int[] createEpochMonths(int epochDay, int minYear, int maxYear, Map<Integer, int[]> years) {
        int numMonths = (maxYear - minYear + 1) * 12 + 1;
        int epochMonth = 0;
        int[] epochMonths = new int[numMonths];
        this.minMonthLength = Integer.MAX_VALUE;
        this.maxMonthLength = Integer.MIN_VALUE;
        for (int year = minYear; year <= maxYear; ++year) {
            int[] months = years.get(year);
            for (int month = 0; month < 12; ++month) {
                int length = months[month];
                epochMonths[epochMonth++] = epochDay;
                if (length < 29 || length > 32) {
                    throw new IllegalArgumentException("Invalid month length in year: " + minYear);
                }
                epochDay += length;
                this.minMonthLength = Math.min(this.minMonthLength, length);
                this.maxMonthLength = Math.max(this.maxMonthLength, length);
            }
        }
        epochMonths[epochMonth++] = epochDay;
        if (epochMonth != epochMonths.length) {
            throw new IllegalStateException("Did not fill epochMonths exactly: ndx = " + epochMonth + " should be " + epochMonths.length);
        }
        return epochMonths;
    }

    private int[] parseMonths(String line) {
        int[] months = new int[12];
        Object[] numbers = line.split("\\s");
        if (numbers.length != 12) {
            throw new IllegalArgumentException("wrong number of months on line: " + Arrays.toString(numbers) + "; count: " + numbers.length);
        }
        for (int i = 0; i < 12; ++i) {
            try {
                months[i] = Integer.parseInt((String)numbers[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("bad key: " + (String)numbers[i]);
            }
        }
        return months;
    }

    private int[] parseYMD(String string) {
        string = string.trim();
        try {
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new IllegalArgumentException("date must be yyyy-MM-dd");
            }
            int[] ymd = new int[]{Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(8, 10))};
            return ymd;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("date must be yyyy-MM-dd", ex);
        }
    }

    public static Date fromIsoEpochDay(long epochDay) {
        long yearEst;
        long doyEst;
        long zeroDay = epochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        return new GregorianCalendar((int)(yearEst += (long)(marchMonth0 / 10)), month - 1, dom).getTime();
    }

    public long toIsoEpochDay(int year, int month, int day) {
        long y = year;
        long m = month;
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(day - 1);
        if (m > 2L) {
            --total;
            if (!this.isIsoLeapYear(year)) {
                --total;
            }
        }
        return total - 719528L;
    }

    public boolean isIsoLeapYear(long prolepticYear) {
        return (prolepticYear & 3L) == 0L && (prolepticYear % 100L != 0L || prolepticYear % 400L == 0L);
    }

    static int[] toHijri(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return INSTANCE.getHijrahDateInfo((int)INSTANCE.toIsoEpochDay(calendar.get(1), calendar.get(2) + 1, calendar.get(5)));
    }

    static int[] toGregorian(int hYear, int hMonth, int hDay) {
        Date date = HijrahChronology.fromIsoEpochDay(INSTANCE.getEpochDay(hYear, hMonth + 1, hDay));
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return new int[]{calendar.get(1), calendar.get(2), calendar.get(5)};
    }

    static int getDaysInMonth(int year, int month) {
        return INSTANCE.getMonthLength(year, month);
    }

    static {
        try {
            INSTANCE = new HijrahChronology();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to initialize Hijrah-umalqura calendar", ex.getCause());
        }
    }
}

