/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class ChoiceFormFieldBuilder
extends TerminalFormFieldBuilder<ChoiceFormFieldBuilder> {
    private PdfArray options = null;

    public ChoiceFormFieldBuilder(PdfDocument document, String formFieldName) {
        super(document, formFieldName);
    }

    public PdfArray getOptions() {
        return this.options;
    }

    public ChoiceFormFieldBuilder setOptions(PdfArray options) {
        ChoiceFormFieldBuilder.verifyOptions(options);
        this.options = options;
        return this;
    }

    public ChoiceFormFieldBuilder setOptions(String[] options) {
        return this.setOptions(ChoiceFormFieldBuilder.processOptions(options));
    }

    public ChoiceFormFieldBuilder setOptions(String[][] options) {
        return this.setOptions(ChoiceFormFieldBuilder.processOptions(options));
    }

    public PdfChoiceFormField createList() {
        return this.createChoice(0);
    }

    public PdfChoiceFormField createComboBox() {
        return this.createChoice(PdfChoiceFormField.FF_COMBO);
    }

    @Override
    protected ChoiceFormFieldBuilder getThis() {
        return this;
    }

    private PdfChoiceFormField createChoice(int flags) {
        PdfChoiceFormField field;
        PdfWidgetAnnotation annotation = null;
        if (this.getWidgetRectangle() == null) {
            field = PdfFormCreator.createChoiceFormField(this.getDocument());
        } else {
            annotation = new PdfWidgetAnnotation(this.getWidgetRectangle());
            if (null != this.getGenericConformanceLevel()) {
                annotation.setFlag(4);
            }
            field = PdfFormCreator.createChoiceFormField(annotation, this.getDocument());
        }
        field.disableFieldRegeneration();
        field.pdfConformanceLevel = this.getGenericConformanceLevel();
        if (this.getFont() != null) {
            field.setFont(this.getFont());
        }
        field.setFieldFlags(flags);
        field.setFieldName(this.getFormFieldName());
        if (this.options == null) {
            field.put(PdfName.Opt, (PdfObject)new PdfArray());
            field.setListSelected(new String[0], false);
        } else {
            field.put(PdfName.Opt, (PdfObject)this.options);
            field.setListSelected(new String[0], false);
            if (annotation != null) {
                this.setPageToField(field);
            }
        }
        field.enableFieldRegeneration();
        return field;
    }

    private static PdfArray processOptions(String[][] options) {
        PdfArray array = new PdfArray();
        for (String[] option : options) {
            if (option.length != 2) {
                throw new IllegalArgumentException("Inner arrays shall have exactly two elements");
            }
            PdfArray subArray = new PdfArray((PdfObject)new PdfString(option[0], "UnicodeBig"));
            subArray.add((PdfObject)new PdfString(option[1], "UnicodeBig"));
            array.add((PdfObject)subArray);
        }
        return array;
    }

    private static void verifyOptions(PdfArray options) {
        for (PdfObject option : options) {
            if (option.isArray()) {
                PdfArray optionsArray = (PdfArray)option;
                if (optionsArray.size() != 2) {
                    throw new IllegalArgumentException("Inner arrays shall have exactly two elements");
                }
                if (optionsArray.get(0).isString() && optionsArray.get(1).isString()) continue;
                throw new IllegalArgumentException("Option element must be a string or an array");
            }
            if (option.isString()) continue;
            throw new IllegalArgumentException("Option element must be a string or an array");
        }
    }

    private static PdfArray processOptions(String[] options) {
        PdfArray array = new PdfArray();
        for (String option : options) {
            array.add((PdfObject)new PdfString(option, "UnicodeBig"));
        }
        return array;
    }
}

