/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.info.EventsLimitInfo;
import com.itextpdf.licensing.base.info.LicenceTypeInfo;
import com.itextpdf.licensing.base.info.LicenseInfo;
import com.itextpdf.licensing.base.info.LimitInfo;
import com.itextpdf.licensing.base.info.LimitInfoType;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.LicenseType;
import com.itextpdf.licensing.base.licensefile.Limit;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

final class LicenseInfoCreator {
    private LicenseInfoCreator() {
    }

    public static LicenseInfo createLicenseInfo(LicenseFile licenseFile, Map<String, Long> leftLimits) {
        Date expire;
        if (licenseFile.getLimits() == null) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Can not find limit for product \"{0}\".", (Object[])new Object[]{licenseFile.getProduct()}));
        }
        try {
            expire = DateTimeUtil.parseWithDefaultPattern((String)licenseFile.getExpirationDate());
        }
        catch (Exception ex) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Invalid expire date for license file which corresponds to \"{0}\" product.", (Object[])new Object[]{licenseFile.getProduct()}));
        }
        EventsLimitInfo eventsLimitInfo = LicenseInfoCreator.createLimitsInfo(licenseFile.getLimits(), leftLimits);
        LicenceTypeInfo licenseType = LicenseInfoCreator.createLicenseType(licenseFile.getLicenseType());
        return new LicenseInfo(licenseFile.getProduct(), expire, licenseType, eventsLimitInfo);
    }

    private static EventsLimitInfo createLimitsInfo(Map<String, Limit> limits, Map<String, Long> leftLimits) {
        LimitInfo defaultLimit = LicenseInfoCreator.createForbiddenLimitsInfo();
        TreeMap<String, LimitInfo> eventLimits = new TreeMap<String, LimitInfo>();
        for (Map.Entry<String, Limit> entry : limits.entrySet()) {
            String eventType = entry.getKey();
            Limit limit = entry.getValue();
            boolean isDefault = "default".equals(eventType);
            LimitInfo limitInfo = LicenseInfoCreator.getEventLimitInfo(limit, leftLimits.get(eventType), isDefault);
            if (isDefault) {
                defaultLimit = limitInfo;
                continue;
            }
            eventLimits.put(eventType, limitInfo);
        }
        if (defaultLimit.getLimitType() == LimitInfoType.VOLUME) {
            for (Map.Entry<String, Object> entry : leftLimits.entrySet()) {
                if (eventLimits.containsKey(entry.getKey())) continue;
                eventLimits.put(entry.getKey(), LicenseInfoCreator.createVolumeLimitsInfo(defaultLimit.getTotalVolume(), (Long)entry.getValue()));
            }
        }
        return new EventsLimitInfo(defaultLimit, eventLimits);
    }

    private static LicenceTypeInfo createLicenseType(LicenseType licenseType) {
        LicenceTypeInfo type;
        switch (licenseType) {
            case oem: {
                type = LicenceTypeInfo.OEM;
                break;
            }
            case nonproduction: {
                type = LicenceTypeInfo.NON_PRODUCTION;
                break;
            }
            case production: {
                type = LicenceTypeInfo.PRODUCTION;
                break;
            }
            case trial: {
                type = LicenceTypeInfo.TRIAL;
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatUtil.format((String)"Unexpected license type \"{0}\".", (Object[])new Object[]{licenseType}));
            }
        }
        return type;
    }

    private static LimitInfo getEventLimitInfo(Limit limit, Long leftLimit, boolean isDefault) {
        LimitInfo limitInfo;
        switch (limit.getLimitType()) {
            case forbidden: {
                limitInfo = LicenseInfoCreator.createForbiddenLimitsInfo();
                break;
            }
            case unlimited: {
                limitInfo = LicenseInfoCreator.createUnlimitedLimitsInfo();
                break;
            }
            case volume: {
                long leftVolume = isDefault || leftLimit == null ? limit.getInitialLimit().longValue() : leftLimit.longValue();
                limitInfo = LicenseInfoCreator.createVolumeLimitsInfo(limit.getInitialLimit(), leftVolume);
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatUtil.format((String)"Unexpected limit type \"{0}\".", (Object[])new Object[]{limit.getLimitType()}));
            }
        }
        return limitInfo;
    }

    private static LimitInfo createForbiddenLimitsInfo() {
        return new LimitInfo(LimitInfoType.FORBIDDEN, 0L, 0L);
    }

    private static LimitInfo createUnlimitedLimitsInfo() {
        return new LimitInfo(LimitInfoType.UNLIMITED, -1L, -1L);
    }

    private static LimitInfo createVolumeLimitsInfo(long totalVolume, long remainingVolume) {
        return new LimitInfo(LimitInfoType.VOLUME, totalVolume, remainingVolume);
    }
}

