/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.licensefile.LimitType;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.ProductLimitsRequest;
import com.itextpdf.licensing.base.reporting.ProductLimitsResponse;
import com.itextpdf.licensing.base.reporting.resultprocessor.TimeWrapperStrategiesProcessor;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.reporting.volume.WaitTime;
import com.itextpdf.licensing.base.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

final class LimitManager {
    private final Object updateEventsLock = new Object();
    private final Map<String, Map<String, Map<String, Long>>> limitsCache = new ConcurrentHashMap<String, Map<String, Map<String, Long>>>();
    private final AtomicLong lastUpdatedTime;
    private volatile boolean lastUpdatedWasSuccess = true;
    private final ILicenseServer server;
    private final TimeWrapperStrategiesProcessor resultProcessor;
    private final WaitTime waitTime;

    LimitManager(ILicenseServer server, long initialWaitTimeMillis, long maxWaitTimeMillis, TimeWrapperStrategiesProcessor resultProcessor) {
        this.server = server;
        this.waitTime = new WaitTime(initialWaitTimeMillis, maxWaitTimeMillis);
        this.resultProcessor = resultProcessor;
        this.lastUpdatedTime = new AtomicLong(SystemUtil.getRelativeTimeMillis());
    }

    boolean hasLeftLimit(LicenseFile licenseFile, String eventType) {
        String productName = licenseFile.getProduct();
        long lastStrategyTime = this.resultProcessor.getLastMethodCallTime(productName, eventType);
        if (lastStrategyTime < this.lastUpdatedTime.get()) {
            if (this.lastUpdatedWasSuccess) {
                this.resultProcessor.onSuccess(productName, eventType);
            } else {
                this.resultProcessor.onFailure(productName, eventType);
            }
        }
        try {
            this.resultProcessor.onEventProcessing(productName, eventType);
        }
        catch (LicenseKeyException e) {
            try {
                this.forceUpdateRemainingEvents();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resultProcessor.onEventProcessing(productName, eventType);
        }
        this.updateRemainingEventsAsync();
        return this.extractRemainingEventsFromCacheForEvent(licenseFile, eventType) > 0L;
    }

    Map<String, Long> getRemainingEvents(LicenseFile licenseFile) {
        this.updateRemainingEvents(true);
        return this.extractRemainingEventsFromCache(licenseFile);
    }

    void forceUpdateRemainingEvents() {
        this.updateRemainingEvents(false);
    }

    long getLastUpdatedTime() {
        return this.lastUpdatedTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemainingEvents(boolean scheduled) {
        Object object = this.updateEventsLock;
        synchronized (object) {
            List<ProductLimitsResponse> responseList;
            if (scheduled && !this.hasProcessingTimeCome()) {
                return;
            }
            List<ProductLimitsRequest> requestList = this.prepareRequestList();
            if (requestList.isEmpty()) {
                return;
            }
            try {
                responseList = this.server.getRemainingEvents(requestList);
                this.lastUpdatedWasSuccess = true;
                this.waitTime.resetTime();
                this.lastUpdatedTime.set(SystemUtil.getRelativeTimeMillis());
            }
            catch (Exception ex) {
                boolean bl = this.lastUpdatedWasSuccess = this.server.healthCheck() == LicenseServerHealthStatus.UNHEALTHY_ON_SERVER_SIDE;
                if (this.lastUpdatedWasSuccess) {
                    responseList = new ArrayList<ProductLimitsResponse>();
                    this.waitTime.resetTime();
                    this.lastUpdatedTime.set(SystemUtil.getRelativeTimeMillis());
                }
                if (scheduled) {
                    this.waitTime.increaseWaitTime();
                    this.lastUpdatedTime.set(SystemUtil.getRelativeTimeMillis());
                }
                throw new LicenseKeyException("Unable to get license file limits.", ex);
            }
            this.updateLimitCache(responseList);
        }
    }

    private void updateRemainingEventsAsync() {
        if (this.hasProcessingTimeCome()) {
            Thread thread = new Thread(() -> {
                try {
                    this.updateRemainingEvents(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }

    private boolean hasProcessingTimeCome() {
        long currentTime = SystemUtil.getRelativeTimeMillis();
        return currentTime - this.lastUpdatedTime.get() > this.waitTime.getTime();
    }

    private long extractRemainingEventsFromCacheForEvent(LicenseFile licenseFile, String eventType) {
        Map<String, Long> remainingEventMap = this.extractRemainingEventsFromCache(licenseFile);
        if (remainingEventMap.containsKey(eventType)) {
            return remainingEventMap.get(eventType);
        }
        Map<String, Limit> limitMap = licenseFile.getLimits();
        Limit limit = null;
        if (limitMap.containsKey(eventType)) {
            limit = limitMap.get(eventType);
        } else if (limitMap.containsKey("default")) {
            limit = limitMap.get("default");
        }
        if (limit == null || limit.getInitialLimit() == null) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Unable to extract remaining events for \"{0}\" type of event \"{1}\" product.", (Object[])new Object[]{eventType, licenseFile.getProduct()}));
        }
        return limit.getInitialLimit();
    }

    private Map<String, Long> extractRemainingEventsFromCache(LicenseFile licenseFile) {
        Map<String, Map<String, Long>> productsCache = this.limitsCache.get(licenseFile.getKey());
        if (productsCache == null) {
            return new HashMap<String, Long>();
        }
        Map<String, Long> eventsCache = productsCache.get(licenseFile.getProduct());
        return eventsCache == null ? new HashMap() : CollectionUtil.unmodifiableMap(eventsCache);
    }

    private void updateLimitCache(List<ProductLimitsResponse> responseList) {
        this.limitsCache.clear();
        for (ProductLimitsResponse response : responseList) {
            LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(response.getProductName());
            Map<String, Limit> limits = licenseFile.getLimits();
            Map<String, Long> leftLimits = response.getLeftLimits();
            Map<String, Map<String, Long>> productsCache = this.limitsCache.get(response.getLicenseKey());
            if (productsCache == null) {
                productsCache = new ConcurrentHashMap<String, Map<String, Long>>();
                this.limitsCache.put(response.getLicenseKey(), productsCache);
            }
            ConcurrentHashMap<String, Long> eventsCache = new ConcurrentHashMap<String, Long>();
            productsCache.put(response.getProductName(), eventsCache);
            for (Map.Entry<String, Long> leftLimit : leftLimits.entrySet()) {
                String eventType = leftLimit.getKey();
                Limit limit = limits.get(eventType);
                if (limit == null) {
                    limit = limits.get("default");
                }
                if (limit == null || !LimitType.volume.equals((Object)limit.getLimitType()) || !limit.getCheckLimits().booleanValue()) continue;
                eventsCache.put(eventType, leftLimit.getValue());
            }
        }
    }

    private List<ProductLimitsRequest> prepareRequestList() {
        List<LicenseFile> licenseFileList = LicenseFileService.getLicenseFiles();
        ArrayList<ProductLimitsRequest> requestList = new ArrayList<ProductLimitsRequest>(licenseFileList.size());
        for (LicenseFile licenseFile : licenseFileList) {
            HashMap<String, Long> events = new HashMap<String, Long>();
            Map<String, Limit> limits = licenseFile.getLimits();
            for (Map.Entry<String, Limit> entry : limits.entrySet()) {
                Limit limit = entry.getValue();
                if (!LimitType.volume.equals((Object)limit.getLimitType()) || !limit.getSendEvents().booleanValue() || !limit.getCheckLimits().booleanValue()) continue;
                events.put(entry.getKey(), (long)limit.getInitialLimit());
            }
            if (events.isEmpty()) continue;
            ProductLimitsRequest request = new ProductLimitsRequest(licenseFile.getKey(), licenseFile.getProduct(), events);
            requestList.add(request);
        }
        return requestList;
    }
}

