/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.licensing.base.reporting.volume.VolumeDataSignature;
import java.util.Objects;

public class VolumeData {
    private final VolumeDataSignature signature;
    private long count;

    public VolumeData(VolumeDataSignature signature, long count) {
        this.signature = signature;
        this.count = count;
    }

    public void mergeWith(VolumeData data) {
        this.count += data.getCount();
    }

    public final VolumeDataSignature getSignature() {
        return this.signature;
    }

    public final long getCount() {
        return this.count;
    }

    public String getLicenseFileKey() {
        return this.getSignature().getLicenseFileKey();
    }

    public String getProductName() {
        return this.getSignature().getProductName();
    }

    public String getEventType() {
        return this.getSignature().getEventType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeData usage = (VolumeData)o;
        return Objects.equals(this.getSignature(), usage.getSignature()) && Objects.equals(this.getCount(), usage.getCount());
    }

    public int hashCode() {
        int result = this.getSignature() != null ? this.getSignature().hashCode() : 0;
        result = 31 * result + (int)(this.getCount() ^ this.getCount() >>> 32);
        return result;
    }
}

