/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.licensing.base.licensefile.ReportingType;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.statistics.AwsStatisticsServer;
import com.itextpdf.licensing.base.statistics.IStatisticsServer;
import com.itextpdf.licensing.base.statistics.LocalFileStatisticsServer;
import org.slf4j.LoggerFactory;

final class StatisticsServerFactory {
    private StatisticsServerFactory() {
    }

    static IStatisticsServer obtainConfiguredStatisticsServer() {
        IStatisticsServer result;
        ReportingType reportingType = LicenseKeyReportingConfigurer.getReportingType();
        switch (reportingType) {
            case remote: {
                result = StatisticsServerFactory.tryToGetAwsStatisticsServer();
                LoggerFactory.getLogger(StatisticsServerFactory.class).info("AWS statistics server is obtained for further processing.");
                break;
            }
            case local: {
                result = LocalFileStatisticsServer.getInstance();
                LoggerFactory.getLogger(StatisticsServerFactory.class).info("Local file statistics server is obtained for further processing.");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reporting type.");
            }
        }
        return result;
    }

    static IStatisticsServer tryToGetAwsStatisticsServer() {
        try {
            return AwsStatisticsServer.getInstance();
        }
        catch (NoClassDefFoundError error) {
            LoggerFactory.getLogger(StatisticsServerFactory.class).info("The 'licensing-remote' library is required for sending statistics to AWS server, but it is missing or outdated. Please add or update this library.");
            return null;
        }
    }
}

