/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.strategy.IStrategy;
import java.util.concurrent.atomic.AtomicLong;

public final class FailStrategy
implements IStrategy {
    private final AtomicLong failCounter = new AtomicLong(0L);
    private final long failLimit;
    private final String exceptionMessage;

    public FailStrategy(String exceptionMessage) {
        this(exceptionMessage, 0L);
    }

    public FailStrategy(String exceptionMessage, long failLimit) {
        this.failLimit = failLimit;
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public void onFailure() {
        long counterValue = this.failCounter.incrementAndGet();
        if (counterValue > this.failLimit) {
            this.failCounter.set(this.failLimit + 1L);
        }
    }

    @Override
    public void onSuccess() {
        this.failCounter.set(0L);
    }

    @Override
    public void onProcessing() {
        if (this.failCounter.get() > this.failLimit) {
            throw new LicenseKeyException(this.exceptionMessage);
        }
    }
}

