/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.licensefile.ReportingType;

public final class LicenseFileUtil {
    private static final long MILLISECONDS_IN_MINUTE = 60000L;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;

    private LicenseFileUtil() {
    }

    public static long parseGracePeriodStrToMilliseconds(String gracePeriod) {
        try {
            String daysStr = gracePeriod.substring(0, gracePeriod.indexOf(100));
            String hoursStr = gracePeriod.substring(gracePeriod.indexOf(100) + 1, gracePeriod.indexOf(104));
            String minutesStr = gracePeriod.substring(gracePeriod.indexOf(104) + 1, gracePeriod.indexOf(109));
            int days = Integer.parseInt(daysStr);
            int hours = Integer.parseInt(hoursStr);
            int minutes = Integer.parseInt(minutesStr);
            return (long)days * 86400000L + (long)hours * 3600000L + (long)minutes * 60000L;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Unable to parse grace period \"{0}\".", (Object[])new Object[]{gracePeriod}));
        }
    }

    public static ReportingType parseStringToReportingType(String toParse) {
        if ("local".equals(toParse)) {
            return ReportingType.local;
        }
        if ("remote".equals(toParse)) {
            return ReportingType.remote;
        }
        throw new IllegalArgumentException("Invalid reporting type.");
    }
}

