/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.utils.JsonUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.auth.AuthData;
import com.itextpdf.licensing.remote.auth.AuthHelper;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.kinesis.KinesisDataSender;

public final class AwsResourcesCreator {
    private static final int LOGIN_TIMEOUT_MILLIS = 15000;
    private static final String AWS_API_LOGIN_HOST = "sdk-login.licensing.itextpdf.com";
    private static final String AWS_API_LOGIN_PATH = "/v1/login";
    private static AwsSdkCredentialsProvider awsSdkCredentialsProvider;

    private AwsResourcesCreator() {
    }

    public static KinesisDataSender createKinesisDataSender(int recordMaxSize, String streamName) {
        return new KinesisDataSender(recordMaxSize, streamName, AwsResourcesCreator.buildAwsSdkCredentials());
    }

    public static ApiGatewayClient createApiGatewayClientWithAuth(String host, String path) {
        return new ApiGatewayClient(host, path, AwsResourcesCreator.buildAwsSdkCredentials());
    }

    public static ApiGatewayClient createApiGatewayClientWithoutAuth(String host, String path) {
        return new ApiGatewayClient(host, path);
    }

    private static AwsSdkCredentialsProvider buildAwsSdkCredentials() {
        if (null == awsSdkCredentialsProvider) {
            ApiGatewayClient apiGatewayClient = new ApiGatewayClient(AWS_API_LOGIN_HOST, AWS_API_LOGIN_PATH).setTimeoutMillis(15000);
            awsSdkCredentialsProvider = new AwsSdkCredentialsProvider(apiGatewayClient, (AuthHelper)new SdkAuthHelper());
        }
        return awsSdkCredentialsProvider;
    }

    private static class SdkAuthHelper
    implements AuthHelper {
        private SdkAuthHelper() {
        }

        public String getBodyForAuthRequest() {
            return JsonUtil.serializeToMinimalString((Object)LicenseFileService.getSomeLoadedLicenseFileWithTryPreserveKey());
        }

        public AuthData parseAuthData(String toParse) {
            return (AuthData)JsonUtil.deserializeFromString((String)toParse, AuthData.class);
        }
    }
}

