/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.info.EventsLimitInfo;
import com.itextpdf.licensing.base.info.LimitInfo;
import com.itextpdf.licensing.base.info.LimitInfoType;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.licensefile.LimitType;
import com.itextpdf.licensing.base.reporting.ProductLimitsRequest;
import com.itextpdf.licensing.base.reporting.ProductLimitsResponse;
import com.itextpdf.licensing.base.util.CollectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class LimitsUtils {
    private LimitsUtils() {
    }

    public static ProductLimitsRequest prepareLeftLimitsRequest(LicenseFile licenseFile) {
        HashMap<String, Long> events = new HashMap<String, Long>();
        Map<String, Limit> limits = licenseFile.getLimits();
        for (Map.Entry<String, Limit> entry : limits.entrySet()) {
            Limit limit = entry.getValue();
            if (!LimitType.volume.equals((Object)limit.getLimitType())) continue;
            events.put(entry.getKey(), (long)limit.getInitialLimit());
        }
        return events.isEmpty() ? null : new ProductLimitsRequest(licenseFile.getKey(), licenseFile.getProduct(), events);
    }

    public static Map<String, Long> getActualLimits(LicenseFile licenseFile, ProductLimitsResponse response) {
        Map<String, Limit> limits = licenseFile.getLimits();
        Map<String, Long> leftLimits = response.getLeftLimits();
        HashMap<String, Long> eventsCache = new HashMap<String, Long>();
        for (Map.Entry<String, Long> leftLimit : leftLimits.entrySet()) {
            String eventType = leftLimit.getKey();
            Limit limit = limits.get(eventType);
            if (limit == null) {
                limit = limits.get("default");
            }
            if (limit == null || !LimitType.volume.equals((Object)limit.getLimitType())) continue;
            eventsCache.put(eventType, leftLimit.getValue());
        }
        return CollectionUtil.unmodifiableMap(eventsCache);
    }

    public static EventsLimitInfo createLimitsInfo(LicenseFile licenseFile, Map<String, Long> leftLimits) {
        LimitInfo defaultLimit = LimitsUtils.createForbiddenLimitsInfo();
        TreeMap<String, LimitInfo> eventLimits = new TreeMap<String, LimitInfo>();
        for (Map.Entry<String, Limit> entry : licenseFile.getLimits().entrySet()) {
            String eventType = entry.getKey();
            Limit limit = entry.getValue();
            boolean isDefault = "default".equals(eventType);
            LimitInfo limitInfo = LimitsUtils.getEventLimitInfo(limit, leftLimits.get(eventType), isDefault);
            if (isDefault) {
                defaultLimit = limitInfo;
                continue;
            }
            eventLimits.put(eventType, limitInfo);
        }
        if (defaultLimit.getLimitType() == LimitInfoType.VOLUME) {
            for (Map.Entry<String, Object> entry : leftLimits.entrySet()) {
                if (eventLimits.containsKey(entry.getKey())) continue;
                eventLimits.put(entry.getKey(), LimitsUtils.createVolumeLimitsInfo(defaultLimit.getTotalVolume(), (Long)entry.getValue()));
            }
        }
        return new EventsLimitInfo(defaultLimit, eventLimits);
    }

    private static LimitInfo getEventLimitInfo(Limit limit, Long leftLimit, boolean isDefault) {
        LimitInfo limitInfo;
        switch (limit.getLimitType()) {
            case forbidden: {
                limitInfo = LimitsUtils.createForbiddenLimitsInfo();
                break;
            }
            case unlimited: {
                limitInfo = LimitsUtils.createUnlimitedLimitsInfo();
                break;
            }
            case volume: {
                long leftVolume = isDefault || leftLimit == null ? limit.getInitialLimit().longValue() : leftLimit.longValue();
                limitInfo = LimitsUtils.createVolumeLimitsInfo(limit.getInitialLimit(), leftVolume);
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatUtil.format((String)"Unexpected limit type \"{0}\".", (Object[])new Object[]{limit.getLimitType()}));
            }
        }
        return limitInfo;
    }

    private static LimitInfo createForbiddenLimitsInfo() {
        return new LimitInfo(LimitInfoType.FORBIDDEN, 0L, 0L);
    }

    private static LimitInfo createUnlimitedLimitsInfo() {
        return new LimitInfo(LimitInfoType.UNLIMITED, -1L, -1L);
    }

    private static LimitInfo createVolumeLimitsInfo(long totalVolume, long remainingVolume) {
        return new LimitInfo(LimitInfoType.VOLUME, totalVolume, remainingVolume);
    }
}

