/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import com.itextpdf.licensing.remote.kinesis.KinesisRecordDataBuffer;

public final class KinesisDataSender {
    private final KinesisRecordDataBuffer buffer;
    private final int capacity;
    private final String streamName;
    private final AwsSdkCredentialsProvider credentialsProvider;
    private final AmazonKinesis client;

    public KinesisDataSender(int capacity, String streamName, AwsSdkCredentialsProvider credentialsProvider) {
        this.buffer = new KinesisRecordDataBuffer(capacity);
        this.capacity = capacity;
        this.streamName = streamName;
        this.credentialsProvider = credentialsProvider;
        this.client = PortingUtil.buildStandardKinesisClient(credentialsProvider);
    }

    public boolean sendRecord(byte[] data) {
        boolean successful;
        if (data.length > this.capacity) {
            throw new LicenseKeyRemoteException("The data record size to be sent is greater than max capacity.");
        }
        boolean didRetriedRequest = false;
        try {
            successful = this.sendRequest(data);
            if (!successful && this.credentialsProvider != null) {
                this.credentialsProvider.refresh();
                didRetriedRequest = true;
                successful = this.sendRequest(data);
            }
        }
        catch (Exception e) {
            if (this.credentialsProvider == null || didRetriedRequest) {
                throw e;
            }
            this.credentialsProvider.refresh();
            successful = this.sendRequest(data);
        }
        return successful;
    }

    private boolean sendRequest(byte[] toSend) {
        KinesisRecordDataBuffer kinesisRecordDataBuffer = this.buffer;
        synchronized (kinesisRecordDataBuffer) {
            try {
                this.buffer.wrap(toSend);
                PutRecordRequest putRecordRequest = new PutRecordRequest();
                putRecordRequest.setStreamName(this.streamName);
                putRecordRequest.setData(this.buffer.toRecordData());
                putRecordRequest.setPartitionKey("partitionKey-" + (int)(PortingUtil.random() * 2.147483647E9));
                return PortingUtil.isSuccessful(this.client.putRecord(putRecordRequest));
            }
            catch (Exception e) {
                throw new LicenseKeyRemoteException(e.getMessage(), e);
            }
        }
    }
}

