/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.kinesis.IKinesisClientProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RotationKinesisClientProvider
implements IKinesisClientProvider {
    private final List<AmazonKinesis> clients;
    private volatile int current = 0;

    public RotationKinesisClientProvider(AmazonKinesis client) {
        if (client == null) {
            throw new IllegalArgumentException("The \"client\" argument must be not null.");
        }
        this.clients = PortingUtil.singletonList(client);
    }

    public RotationKinesisClientProvider(Collection<AmazonKinesis> clients) {
        this.clients = new ArrayList<AmazonKinesis>();
        for (AmazonKinesis client : clients) {
            if (client == null) continue;
            this.clients.add(client);
        }
        if (this.clients.isEmpty()) {
            throw new IllegalArgumentException("The \"clients\" argument must contain at least one not null client.");
        }
    }

    @Override
    public AmazonKinesis getClient() {
        return this.clients.get(this.current);
    }

    @Override
    public void refresh() {
        int local = this.current + 1;
        if (local >= this.clients.size()) {
            local = 0;
        }
        this.current = local;
    }
}

