/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.dependencies;

import com.mycila.maven.plugin.license.dependencies.LicenseMap;
import com.mycila.maven.plugin.license.dependencies.LicenseMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuilder;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.internal.Maven31DependencyGraphBuilder;

public class MavenProjectLicenses
implements LicenseMap,
LicenseMessage {
    private Set<MavenProject> projects;
    private MavenSession session;
    private DependencyGraphBuilder graph;
    private ProjectBuilder projectBuilder;
    private ProjectBuildingRequest buildingRequest;
    private ArtifactFilter filter;
    private Log log;

    public MavenProjectLicenses(Set<MavenProject> projects, DependencyGraphBuilder graph, ProjectBuilder projectBuilder, ProjectBuildingRequest buildingRequest, ArtifactFilter filter, Log log) {
        this.setProjects(projects);
        this.setBuildingRequest(buildingRequest);
        this.setGraph(graph);
        this.setFilter(filter);
        this.setProjectBuilder(projectBuilder);
        this.setLog(log);
        log.info((CharSequence)String.format("%s %s", "Checking licenses in dependencies using", this.getClass()));
    }

    public MavenProjectLicenses(MavenSession session, MavenProject project, DependencyGraphBuilder graph, ProjectBuilder projectBuilder, List<String> scopes, Log log) {
        this(Collections.singleton(project), graph, projectBuilder, MavenProjectLicenses.getBuildingRequestWithDefaults(session), (ArtifactFilter)new CumulativeScopeArtifactFilter(scopes), log);
    }

    private static ProjectBuildingRequest getBuildingRequestWithDefaults(MavenSession session) {
        Object request = session == null ? new DefaultProjectBuildingRequest() : session.getProjectBuildingRequest();
        return request;
    }

    protected Set<License> getLicensesFromArtifact(Artifact artifact) {
        HashSet<License> licenses = new HashSet<License>();
        try {
            MavenProject project = this.getProjectBuilder().build(artifact, this.getBuildingRequest()).getProject();
            licenses.addAll(project.getLicenses());
        }
        catch (ProjectBuildingException ex) {
            this.getLog().warn((CharSequence)String.format("Could not get project from dependency's artifact: %s", artifact.getFile()));
        }
        return licenses;
    }

    protected Map<License, Set<Artifact>> getLicenseMapFromArtifacts(Set<Artifact> dependencies) {
        ConcurrentHashMap<License, Set<Artifact>> map = new ConcurrentHashMap<License, Set<Artifact>>();
        dependencies.parallelStream().forEach(artifact -> this.getLicensesFromArtifact((Artifact)artifact).forEach(license -> {
            map.putIfAbsent((License)license, new HashSet());
            Set artifacts = (Set)map.get(license);
            artifacts.add(artifact);
            map.put((License)license, artifacts);
        }));
        return map;
    }

    @Override
    public Map<License, Set<Artifact>> getLicenseMap() {
        return this.getLicenseMapFromArtifacts(this.getDependencies());
    }

    private Set<Artifact> getDependencies() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet dependencies = new HashSet();
        this.getLog().debug((CharSequence)String.format("Building dependency graphs for %d projects", this.getProjects().size()));
        this.getProjects().parallelStream().forEach(project -> {
            try {
                dependencies.addAll(this.getGraph().buildDependencyGraph(project, this.getFilter()).getChildren());
            }
            catch (DependencyGraphBuilderException ex) {
                this.getLog().warn((CharSequence)String.format("Could not get children from project %s, it's dependencies will not be checked!", project.getId()));
            }
        });
        dependencies.parallelStream().forEach(d -> artifacts.add(d.getArtifact()));
        this.getLog().info((CharSequence)String.format("%s: %d", "Discovered dependencies after filtering", dependencies.size()));
        return artifacts;
    }

    private MavenSession getSession() {
        return this.session;
    }

    private void setSession(MavenSession session) {
        this.session = session;
    }

    protected Set<MavenProject> getProjects() {
        return this.projects;
    }

    protected void setProjects(Set<MavenProject> projects) {
        this.projects = Optional.ofNullable(projects).orElse(new HashSet());
    }

    private DependencyGraphBuilder getGraph() {
        return this.graph;
    }

    private void setGraph(DependencyGraphBuilder graph) {
        this.graph = Optional.ofNullable(graph).orElse((DependencyGraphBuilder)new Maven31DependencyGraphBuilder());
    }

    private ProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    private void setProjectBuilder(ProjectBuilder projectBuilder) {
        this.projectBuilder = Optional.ofNullable(projectBuilder).orElse((ProjectBuilder)new DefaultProjectBuilder());
    }

    private ArtifactFilter getFilter() {
        return this.filter;
    }

    private void setFilter(ArtifactFilter filter) {
        this.filter = filter;
    }

    private Log getLog() {
        return this.log;
    }

    private void setLog(Log log) {
        this.log = log;
    }

    private ProjectBuildingRequest getBuildingRequest() {
        return this.buildingRequest;
    }

    protected void setBuildingRequest(ProjectBuildingRequest buildingRequest) {
        this.buildingRequest = Optional.ofNullable(buildingRequest).orElse((ProjectBuildingRequest)new DefaultProjectBuildingRequest());
    }
}

