/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.Multi;
import com.mycila.maven.plugin.license.util.FileUtils;
import com.mycila.maven.plugin.license.util.resource.ResourceFinder;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.MojoFailureException;

public abstract class HeaderSource {
    protected final String content;
    private final boolean inline;

    private static String combineHeaders(String preamble, String[] headers, String[] separators) {
        StringBuilder builder = new StringBuilder();
        if (preamble != null) {
            builder.append(preamble);
            if (!preamble.endsWith("\n")) {
                builder.append('\n');
            }
            builder.append('\n');
        }
        for (int i = 0; i < headers.length; ++i) {
            String separator = null;
            if (i > 0) {
                separator = separators == null ? "---------------------------------------------------------------------" : (separators.length == 1 ? separators[0] : separators[i - 1]);
                if (builder.charAt(builder.length() - 1) != '\n') {
                    builder.append('\n');
                }
                builder.append('\n');
                builder.append(separator);
                if (!separator.endsWith("\n")) {
                    builder.append('\n');
                }
                builder.append('\n');
            }
            String header = headers[i];
            builder.append(header);
        }
        return builder.toString();
    }

    public static HeaderSource of(String headerPath, String encoding, ResourceFinder finder) {
        return HeaderSource.of(null, encoding, finder);
    }

    public static HeaderSource of(Multi multi, String inlineHeader, String headerPath, String encoding, ResourceFinder finder) {
        if (multi != null) {
            if (multi.getInlineHeaders() != null && multi.getInlineHeaders().length > 0) {
                return new MultiLiteralHeaderSource(multi.getPreamble(), multi.getInlineHeaders(), multi.getSeparators());
            }
            if (multi.getHeaders() == null || multi.getHeaders().length == 0) {
                throw new IllegalArgumentException("Either multi/inlineHeader or multi/header path needs to be specified");
            }
            URL[] headerUrls = new URL[multi.getHeaders().length];
            for (int i = 0; i < multi.getHeaders().length; ++i) {
                try {
                    URL headerUrl;
                    headerPath = multi.getHeaders()[i];
                    headerUrls[i] = headerUrl = finder.findResource(headerPath);
                    continue;
                }
                catch (MojoFailureException e) {
                    throw new IllegalArgumentException("Cannot read header document " + headerPath + ". Cause: " + e.getMessage(), e);
                }
            }
            try {
                return new MultiUrlHeaderSource(multi.getPreamble(), headerUrls, multi.getSeparators(), encoding);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read multi header documents. Cause: " + e.getMessage(), e);
            }
        }
        if (inlineHeader != null && !inlineHeader.isEmpty()) {
            return new LiteralHeaderSource(inlineHeader);
        }
        if (headerPath == null) {
            throw new IllegalArgumentException("Either inlineHeader or header path needs to be specified");
        }
        try {
            URL headerUrl = finder.findResource(headerPath);
            return new UrlHeaderSource(headerUrl, encoding);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + headerPath + ". Cause: " + e.getMessage(), e);
        }
    }

    public HeaderSource(String content, boolean inline) {
        this.content = content;
        this.inline = inline;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isInline() {
        return this.inline;
    }

    public abstract boolean isFromUrl(URL var1);

    public static class MultiUrlHeaderSource
    extends HeaderSource {
        private final URL[] urls;

        public MultiUrlHeaderSource(String preamble, URL[] urls, String[] separators, String encoding) throws IOException {
            super(HeaderSource.combineHeaders(preamble, FileUtils.read(urls, encoding), separators), false);
            this.urls = urls;
        }

        @Override
        public boolean isFromUrl(URL location) {
            for (URL url : this.urls) {
                if (!url.equals(location)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            for (URL url : this.urls) {
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                builder.append(url);
            }
            builder.append("] : ").append(this.content);
            return builder.toString();
        }
    }

    public static class MultiLiteralHeaderSource
    extends HeaderSource {
        public MultiLiteralHeaderSource(String preamble, String[] contents, String[] separators) {
            super(HeaderSource.combineHeaders(preamble, contents, separators), true);
        }

        @Override
        public boolean isFromUrl(URL location) {
            return false;
        }

        public String toString() {
            return "inline: " + this.content;
        }
    }

    public static class UrlHeaderSource
    extends HeaderSource {
        private final URL url;

        public UrlHeaderSource(URL url, String encoding) throws IOException {
            super(FileUtils.read(url, encoding), false);
            this.url = url;
        }

        @Override
        public boolean isFromUrl(URL location) {
            return this.url.equals(location);
        }

        public String toString() {
            return this.url + ": " + this.content;
        }
    }

    public static class LiteralHeaderSource
    extends HeaderSource {
        public LiteralHeaderSource(String content) {
            super(content, true);
        }

        @Override
        public boolean isFromUrl(URL location) {
            return false;
        }

        public String toString() {
            return "inline: " + this.content;
        }
    }
}

