/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.stats.distribution;

import com.netflix.stats.distribution.DataAccumulator;
import com.netflix.stats.distribution.DataBuffer;
import com.netflix.stats.distribution.DataDistributionMBean;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Date;

public class DataDistribution
extends DataAccumulator
implements DataDistributionMBean {
    private long numValues = 0L;
    private double mean = 0.0;
    private double variance = 0.0;
    private double stddev = 0.0;
    private double min = 0.0;
    private double max = 0.0;
    private long ts = 0L;
    private long interval = 0L;
    private int size = 0;
    private final double[] percents;
    private final double[] percentiles;

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public DataDistribution(int bufferSize, double[] percents) {
        super(bufferSize);
        assert (DataDistribution.percentsOK(percents));
        this.percents = percents;
        this.percentiles = new double[percents.length];
    }

    private static boolean percentsOK(double[] percents) {
        if (percents == null) {
            return false;
        }
        for (int i = 0; i < percents.length; ++i) {
            if (!(percents[i] < 0.0) && !(percents[i] > 100.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void publish(DataBuffer buf) {
        this.ts = System.currentTimeMillis();
        this.numValues = buf.getNumValues();
        this.mean = buf.getMean();
        this.variance = buf.getVariance();
        this.stddev = buf.getStdDev();
        this.min = buf.getMinimum();
        this.max = buf.getMaximum();
        this.interval = buf.getSampleIntervalMillis();
        this.size = buf.getSampleSize();
        buf.getPercentiles(this.percents, this.percentiles);
    }

    @Override
    public void clear() {
        this.numValues = 0L;
        this.mean = 0.0;
        this.variance = 0.0;
        this.stddev = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.ts = 0L;
        this.interval = 0L;
        this.size = 0;
        for (int i = 0; i < this.percentiles.length; ++i) {
            this.percentiles[i] = 0.0;
        }
    }

    @Override
    public long getNumValues() {
        return this.numValues;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getStdDev() {
        return this.stddev;
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public String getTimestamp() {
        return new Date(this.getTimestampMillis()).toString();
    }

    @Override
    public long getTimestampMillis() {
        return this.ts;
    }

    @Override
    public long getSampleIntervalMillis() {
        return this.interval;
    }

    @Override
    public int getSampleSize() {
        return this.size;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public double[] getPercents() {
        return this.percents;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public double[] getPercentiles() {
        return this.percentiles;
    }
}

