/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.nio.file.Paths;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00070\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/FilenameRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "ignoreSet", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class FilenameRule
extends Rule {
    @NotNull
    private final Set<IElementType> ignoreSet;

    public FilenameRule() {
        super("filename", SetsKt.setOf((Object)Rule.VisitorModifier.RunOnRootNodeOnly.INSTANCE));
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getFILE_ANNOTATION_LIST(), ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getIMPORT_LIST(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getKDOC(), ElementType.INSTANCE.getSHEBANG_COMMENT()};
        this.ignoreSet = SetsKt.setOf((Object[])objectArray);
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        String filePath;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        String string = filePath = (String)node.getUserData(KtLint.INSTANCE.getFILE_PATH_USER_DATA_KEY());
        if (!(string == null ? false : StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null))) {
            return;
        }
        String type = null;
        String className = null;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
        ASTNode[] aSTNodeArray2 = aSTNodeArray;
        int n = 0;
        int n2 = aSTNodeArray2.length;
        while (n < n2) {
            ASTNode el = aSTNodeArray2[n];
            ++n;
            if (Intrinsics.areEqual((Object)el.getElementType(), (Object)ElementType.INSTANCE.getCLASS()) || Intrinsics.areEqual((Object)el.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) || Intrinsics.areEqual((Object)el.getElementType(), (Object)ElementType.INSTANCE.getTYPEALIAS())) {
                String string2;
                ASTNode id;
                if (className != null) {
                    return;
                }
                ASTNode aSTNode = id = el.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                if (aSTNode == null) {
                    string2 = null;
                } else {
                    ASTNode aSTNode2 = PackageKt.prevCodeSibling((ASTNode)aSTNode);
                    string2 = aSTNode2 == null ? null : aSTNode2.getText();
                }
                type = string2;
                ASTNode aSTNode3 = id;
                className = aSTNode3 == null ? null : aSTNode3.getText();
                continue;
            }
            if (this.ignoreSet.contains(el.getElementType())) continue;
            return;
        }
        if (className != null) {
            String unescapedClassName = StringsKt.replace$default(className, (String)"`", (String)"", (boolean)false, (int)4, null);
            String name = StringsKt.substringBefore$default((String)((Object)Paths.get(filePath, new String[0]).getFileName()).toString(), (String)".", null, (int)2, null);
            if (!Intrinsics.areEqual((Object)name, (Object)"package") && !Intrinsics.areEqual((Object)name, (Object)unescapedClassName)) {
                emit.invoke((Object)0, (Object)(type + ' ' + className + " should be declared in a file named " + unescapedClassName + ".kt"), (Object)false);
            }
        }
    }
}

