/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.IndentationRuleKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\b\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002\u001a \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000e*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lmu/KLogger;", "getFirstElementOnSameLine", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "isClosingQuote", "", "isFirstNonBlankElementOnLine", "isIndentBeforeClosingQuote", "isKDocIndent", "isLiteralStringTemplateEntry", "isVariableStringTemplateEntry", "isWhitespace", "", "splitIndentAt", "Lkotlin/Pair;", "index", "", "ktlint-ruleset-standard"})
public final class IndentationRuleKt {
    @NotNull
    private static final KLogger logger = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKDocIndent(ASTNode $this$isKDocIndent) {
        String string = $this$isKDocIndent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        Character c = StringsKt.lastOrNull((CharSequence)string);
        char c2 = ' ';
        if (c == null) return false;
        if (c.charValue() != c2) return false;
        ASTNode aSTNode = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null);
        if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) return true;
        ASTNode aSTNode2 = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null);
        if (!Intrinsics.areEqual((Object)(aSTNode2 == null ? null : aSTNode2.getElementType()), (Object)ElementType.INSTANCE.getKDOC_END())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIndentBeforeClosingQuote(ASTNode $this$isIndentBeforeClosingQuote) {
        if (Intrinsics.areEqual((Object)$this$isIndentBeforeClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return true;
        String string = $this$isIndentBeforeClosingQuote.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.isBlank((CharSequence)string)) return false;
        ASTNode aSTNode = PackageKt.nextCodeSibling((ASTNode)$this$isIndentBeforeClosingQuote);
        if (!Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
        return true;
    }

    private static final boolean isLiteralStringTemplateEntry(ASTNode $this$isLiteralStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY()) && !Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getText(), (Object)"\n");
    }

    private static final boolean isVariableStringTemplateEntry(ASTNode $this$isVariableStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY()) || Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY());
    }

    private static final boolean isClosingQuote(ASTNode $this$isClosingQuote) {
        return Intrinsics.areEqual((Object)$this$isClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE());
    }

    private static final boolean isFirstNonBlankElementOnLine(ASTNode $this$isFirstNonBlankElementOnLine) {
        ASTNode node = IndentationRuleKt.getFirstElementOnSameLine($this$isFirstNonBlankElementOnLine);
        while (node != null && !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine)) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (!IndentationRuleKt.isWhitespace(string)) break;
            node = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
        }
        return !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine);
    }

    private static final boolean isWhitespace(String $this$isWhitespace) {
        boolean bl;
        block1: {
            CharSequence $this$none$iv = $this$isWhitespace;
            boolean $i$f$none = false;
            CharSequence charSequence = $this$none$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final ASTNode getFirstElementOnSameLine(ASTNode $this$getFirstElementOnSameLine) {
        ASTNode aSTNode;
        ASTNode firstLeafOnLine2 = PackageKt.prevLeaf((ASTNode)$this$getFirstElementOnSameLine, (Function1)getFirstElementOnSameLine.firstLeafOnLine.1.INSTANCE);
        if (firstLeafOnLine2 == null) {
            aSTNode = $this$getFirstElementOnSameLine;
        } else {
            aSTNode = PackageKt.nextLeaf$default((ASTNode)firstLeafOnLine2, (boolean)true, (boolean)false, (int)2, null);
            if (aSTNode == null) {
                aSTNode = $this$getFirstElementOnSameLine;
            }
        }
        return aSTNode;
    }

    private static final Pair<String, String> splitIndentAt(String $this$splitIndentAt, int index) {
        int n;
        block2: {
            boolean bl;
            boolean bl2 = bl = index >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CharSequence $this$indexOfFirst$iv = $this$splitIndentAt;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                int index$iv = n2++;
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl3 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        int firstNonWhitespaceIndex = it == -1 ? $this$splitIndentAt.length() : it;
        int safeIndex = Math.min(firstNonWhitespaceIndex, index);
        String string = StringsKt.take((String)$this$splitIndentAt, (int)safeIndex);
        String string2 = $this$splitIndentAt.substring(safeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string2);
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$isKDocIndent(ASTNode $receiver) {
        return IndentationRuleKt.isKDocIndent($receiver);
    }

    public static final /* synthetic */ Pair access$splitIndentAt(String $receiver, int index) {
        return IndentationRuleKt.splitIndentAt($receiver, index);
    }

    public static final /* synthetic */ boolean access$isIndentBeforeClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isIndentBeforeClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isLiteralStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isLiteralStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isVariableStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isVariableStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isFirstNonBlankElementOnLine(ASTNode $receiver) {
        return IndentationRuleKt.isFirstNonBlankElementOnLine($receiver);
    }

    public static final /* synthetic */ ASTNode access$getFirstElementOnSameLine(ASTNode $receiver) {
        return IndentationRuleKt.getFirstElementOnSameLine($receiver);
    }
}

