/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.MaxLineLengthRuleKt;
import com.pinterest.ktlint.ruleset.standard.ParsedLine;
import com.pinterest.ktlint.ruleset.standard.RangeTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003Je\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122K\u0010\u0013\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\f\u0010\u001b\u001a\u00020\u0012*\u00020\u0010H\u0002R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/MaxLineLengthRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "maxLineLength", "", "rangeTree", "Lcom/pinterest/ktlint/ruleset/standard/RangeTree;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isPartOfRawMultiLineString", "Companion", "ktlint-ruleset-standard"})
public final class MaxLineLengthRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties;
    private int maxLineLength;
    @NotNull
    private RangeTree rangeTree;
    @NotNull
    public static final String KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME = "ktlint_ignore_back_ticked_identifier";
    @NotNull
    private static final String PROPERTY_DESCRIPTION = "Defines whether the backticked identifier (``) should be ignored";
    @NotNull
    private static final UsesEditorConfigProperties.EditorConfigProperty<Boolean> ignoreBackTickedIdentifierProperty;

    public MaxLineLengthRule() {
        Object[] objectArray = new Rule.VisitorModifier[]{(Rule.VisitorModifier)new Rule.VisitorModifier.RunAfterRule("experimental:trailing-comma", false, false), (Rule.VisitorModifier)Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE};
        super("max-line-length", SetsKt.setOf((Object[])objectArray));
        this.editorConfigProperties = CollectionsKt.listOf(ignoreBackTickedIdentifierProperty);
        this.maxLineLength = -1;
        this.rangeTree = new RangeTree(null, 1, null);
    }

    @NotNull
    public List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            void $this$forEach$iv;
            Object it;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object = node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_PROPERTIES_USER_DATA_KEY());
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"node.getUserData(KtLint.\u2026OPERTIES_USER_DATA_KEY)!!");
            Map editorConfigProperties = (Map)object2;
            boolean ignoreBackTickedIdentifier = (Boolean)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue$default((UsesEditorConfigProperties)this, (Map)editorConfigProperties, ignoreBackTickedIdentifierProperty, (boolean)false, (int)2, null);
            this.maxLineLength = EditorConfig.Companion.loadEditorConfig(node).getMaxLineLength();
            if (this.maxLineLength <= 0) {
                return;
            }
            ArrayList<Integer> errorOffset = new ArrayList<Integer>();
            Iterable iterable = MaxLineLengthRuleKt.access$getElementsPerLine(node);
            boolean $i$f$filter = false;
            void var9_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (ParsedLine)element$iv$iv;
                boolean bl = false;
                if (!(((ParsedLine)it).lineLength(ignoreBackTickedIdentifier) > this.maxLineLength)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode prevLeaf2;
                ParsedLine parsedLine = (ParsedLine)element$iv;
                boolean bl = false;
                ASTNode el = (ASTNode)CollectionsKt.last(parsedLine.getElements());
                if (PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KDoc.class)) || this.isPartOfRawMultiLineString(el)) continue;
                if (!PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    if (PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtPackageDirective.class)) || PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) continue;
                    errorOffset.add(parsedLine.getOffset());
                    continue;
                }
                it = el.getText();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"el.text");
                if (StringsKt.startsWith$default((String)it, (String)"// ktlint-disable", (boolean)false, (int)2, null) || (prevLeaf2 = PackageKt.prevCodeSibling((ASTNode)el)) == null || prevLeaf2.getStartOffset() < parsedLine.getOffset()) continue;
                errorOffset.add(parsedLine.getOffset());
            }
            this.rangeTree = new RangeTree((List<Integer>)errorOffset);
        } else if (!this.rangeTree.isEmpty() && node.getPsi() instanceof LeafPsiElement) {
            void this_$iv;
            RangeTree.ArrayView editorConfigProperties = this.rangeTree.query(node.getStartOffset(), node.getStartOffset() + node.getTextLength());
            boolean $i$f$forEach = false;
            int i$iv = 0;
            while (i$iv < this_$iv.getSize()) {
                int n = i$iv;
                i$iv = n + 1;
                int offset = this_$iv.get(n);
                boolean bl = false;
                emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
            }
        }
    }

    private final boolean isPartOfRawMultiLineString(ASTNode $this$isPartOfRawMultiLineString) {
        boolean bl;
        ASTNode aSTNode = PackageKt.parent((ASTNode)$this$isPartOfRawMultiLineString, (IElementType)ElementType.INSTANCE.getSTRING_TEMPLATE(), (boolean)false);
        if (aSTNode == null) {
            bl = false;
        } else {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getFirstChildNode().getText(), (Object)"\"\"\"") && it.textContains('\n');
        }
        return bl;
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> property, boolean isAndroidCodeStyle) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, property, (boolean)isAndroidCodeStyle);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> property, boolean isAndroidCodeStyle) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, property, (boolean)isAndroidCodeStyle);
    }

    static {
        String[] stringArray = new String[]{"true", "false"};
        ignoreBackTickedIdentifierProperty = new UsesEditorConfigProperties.EditorConfigProperty((PropertyType)new PropertyType.LowerCasingPropertyType(KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME, PROPERTY_DESCRIPTION, PropertyType.PropertyValueParser.BOOLEAN_VALUE_PARSER, stringArray), (Object)false, null, null, 12, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/MaxLineLengthRule$Companion;", "", "()V", "KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME", "", "PROPERTY_DESCRIPTION", "ignoreBackTickedIdentifierProperty", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "", "getIgnoreBackTickedIdentifierProperty", "()Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsesEditorConfigProperties.EditorConfigProperty<Boolean> getIgnoreBackTickedIdentifierProperty() {
            return ignoreBackTickedIdentifierProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

