/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.NoSemicolonsRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0002Je\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/NoSemicolonsRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "doesNotRequirePostSemi", "", "prevLeaf", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "doesNotRequirePreSemi", "nextLeaf", "visit", "", "node", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isPartOfEnumEntry", "ktlint-ruleset-standard"})
public final class NoSemicolonsRule
extends Rule {
    public NoSemicolonsRule() {
        super("no-semi", null, 2, null);
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT())) {
            return;
        }
        if (node instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)node).getElementType(), (Object)ElementType.INSTANCE.getSEMICOLON()) && !PackageKt.isPartOfString((ASTNode)node) && !this.isPartOfEnumEntry(node)) {
            ASTNode nextLeaf = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            ASTNode prevCodeLeaf = PackageKt.prevCodeLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (this.doesNotRequirePreSemi(nextLeaf) && this.doesNotRequirePostSemi(prevCodeLeaf)) {
                emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)"Unnecessary semicolon", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).getTreeParent().removeChild(node);
                }
            } else if (!(nextLeaf instanceof PsiWhiteSpace)) {
                ASTNode prevLeaf2 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
                if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                    return;
                }
                emit.invoke((Object)(((LeafPsiElement)node).getStartOffset() + 1), (Object)"Missing spacing after \";\"", (Object)true);
                if (autoCorrect) {
                    PackageKt.upsertWhitespaceAfterMe((LeafElement)((LeafElement)node), (String)" ");
                }
            }
        }
    }

    private final boolean doesNotRequirePreSemi(ASTNode nextLeaf) {
        if (nextLeaf instanceof PsiWhiteSpace) {
            ASTNode nextNextLeaf2 = PackageKt.nextLeaf((ASTNode)nextLeaf, (Function1)doesNotRequirePreSemi.nextNextLeaf.1.INSTANCE);
            return nextNextLeaf2 == null || nextLeaf.textContains('\n') && !Intrinsics.areEqual((Object)nextNextLeaf2.getElementType(), (Object)KtTokens.LBRACE);
        }
        return nextLeaf == null;
    }

    private final boolean doesNotRequirePostSemi(ASTNode prevLeaf2) {
        PsiElement parent;
        Object object;
        ASTNode aSTNode = prevLeaf2;
        if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getOBJECT_KEYWORD())) {
            return false;
        }
        ASTNode aSTNode2 = prevLeaf2;
        if (aSTNode2 == null) {
            object = null;
        } else {
            ASTNode aSTNode3 = aSTNode2.getTreeParent();
            object = parent = aSTNode3 == null ? null : aSTNode3.getPsi();
        }
        if (parent instanceof KtLoopExpression && !(parent instanceof KtDoWhileExpression) && ((KtLoopExpression)parent).getBody() == null) {
            return false;
        }
        return !(parent instanceof KtIfExpression) || ((KtIfExpression)parent).getThen() != null;
    }

    private final boolean isPartOfEnumEntry(ASTNode $this$isPartOfEnumEntry) {
        PsiElement psiElement;
        PsiElement psiElement2;
        Object object;
        if (PackageKt.isPartOf((ASTNode)$this$isPartOfEnumEntry, (KClass)Reflection.getOrCreateKotlinClass(KtEnumEntry.class))) {
            return true;
        }
        PsiElement psiElement3 = PackageKt.prevLeaf((ASTNode)$this$isPartOfEnumEntry, (Function1)isPartOfEnumEntry.lBrace.1.INSTANCE);
        if (psiElement3 == null) {
            object = null;
        } else {
            PsiElement it = psiElement2 = psiElement3;
            boolean bl = false;
            object = psiElement = Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.LBRACE) ? psiElement2 : null;
        }
        if (psiElement == null) {
            return false;
        }
        PsiElement lBrace2 = psiElement;
        ASTNode aSTNode = lBrace2.getTreeParent();
        psiElement2 = aSTNode == null ? null : aSTNode.getPsi();
        KtClassBody ktClassBody = psiElement2 instanceof KtClassBody ? (KtClassBody)psiElement2 : null;
        if (ktClassBody == null) {
            return false;
        }
        KtClassBody classBody = ktClassBody;
        psiElement3 = classBody.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"classBody.children");
        if (((Object[])psiElement3).length == 0) {
            return false;
        }
        psiElement2 = classBody.getParent();
        KtClass ktClass = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
        return ktClass == null ? false : ktClass.isEnum();
    }
}

