/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.NoTrailingSpacesRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\f\u0010\u0012\u001a\u00020\b*\u00020\u000fH\u0002J\f\u0010\u0013\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/NoTrailingSpacesRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "hasTrailingSpace", "hasTrailingSpacesBeforeNewline", "isPartOfKDoc", "removeTrailingSpacesBeforeNewline", "ktlint-ruleset-standard"})
public final class NoTrailingSpacesRule
extends Rule {
    public NoTrailingSpacesRule() {
        super("no-trailing-spaces", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.isPartOfKDoc(node)) {
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && this.hasTrailingSpacesBeforeNewline(node)) {
                emit.invoke((Object)node.getStartOffset(), (Object)"Trailing space(s)", (Object)true);
                if (autoCorrect) {
                    this.removeTrailingSpacesBeforeNewline(node);
                }
            }
        } else if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || PackageKt.isPartOfComment((ASTNode)node)) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            String[] stringArray = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"node.text");
            CharSequence charSequence = (CharSequence)stringArray;
            stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean violated = false;
            int violationOffset = 0;
            violationOffset = node.getStartOffset();
            Iterable iterable = lines;
            boolean $i$f$mapIndexed = false;
            void var10_10 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                String string;
                void line;
                void index;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()) && index == lines.size() - 1 && PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null) != null) {
                    string = line;
                } else if (this.hasTrailingSpace((String)line)) {
                    String modifiedLine = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)line))).toString();
                    int firstTrailingSpaceOffset = violationOffset + modifiedLine.length();
                    emit.invoke((Object)firstTrailingSpaceOffset, (Object)"Trailing space(s)", (Object)true);
                    violated = true;
                    string = modifiedLine;
                } else {
                    string = line;
                }
                void modifiedLine = string;
                violationOffset += line.length() + 1;
                collection.add(modifiedLine);
            }
            List modifiedLines = (List)destination$iv$iv;
            if (violated && autoCorrect) {
                ((LeafPsiElement)node).rawReplaceWithText(CollectionsKt.joinToString$default((Iterable)modifiedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    private final boolean isPartOfKDoc(ASTNode $this$isPartOfKDoc) {
        return PackageKt.parent((ASTNode)$this$isPartOfKDoc, (Function1)isPartOfKDoc.1.INSTANCE, (boolean)false) != null;
    }

    private final boolean hasTrailingSpacesBeforeNewline(ASTNode $this$hasTrailingSpacesBeforeNewline) {
        CharSequence charSequence = $this$hasTrailingSpacesBeforeNewline.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"text");
        charSequence = charSequence;
        return new Regex("\\s+\\n").containsMatchIn(charSequence);
    }

    private final void removeTrailingSpacesBeforeNewline(ASTNode $this$removeTrailingSpacesBeforeNewline) {
        CharSequence charSequence = $this$removeTrailingSpacesBeforeNewline.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"text");
        charSequence = charSequence;
        Regex regex = new Regex("\\s+\\n");
        String string = "\n";
        String newText = regex.replace(charSequence, string);
        ((LeafPsiElement)$this$removeTrailingSpacesBeforeNewline).replaceWithText(newText);
    }

    private final boolean hasTrailingSpace(String $this$hasTrailingSpace) {
        return Intrinsics.areEqual((Object)StringsKt.takeLast((String)$this$hasTrailingSpace, (int)1), (Object)" ");
    }
}

