
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for GeneratedReason3Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="GeneratedReason3Code">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="COLL"/>
 *     <enumeration value="CLAI"/>
 *     <enumeration value="OTHR"/>
 *     <enumeration value="RODE"/>
 *     <enumeration value="SPLI"/>
 *     <enumeration value="THRD"/>
 *     <enumeration value="TRAN"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "GeneratedReason3Code")
@XmlEnum
public enum GeneratedReason3Code {


    /**
     * Transaction has been generated for collateral management purposes.
     * 
     */
    COLL,

    /**
     * Transaction resulting from a market claim.
     * 
     */
    CLAI,

    /**
     * Other. See Narrative.
     * 
     */
    OTHR,

    /**
     * Relates to the return of financial instruments resulting from a rejected delivery without matching operation.
     * 
     */
    RODE,

    /**
     * Transaction has been generated to enable settlement following a shortage of position.
     * 
     */
    SPLI,

    /**
     * Transaction has been generated by a third party, for example, a central counterparty.
     * 
     */
    THRD,

    /**
     * Transaction has been generated due to transformation following a corporate action.
     * 
     */
    TRAN;

    public String value() {
        return name();
    }

    public static GeneratedReason3Code fromValue(String v) {
        return valueOf(v);
    }

}
