/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.runners.Parameterized;
import org.junit.runners.model.RunnerScheduler;

public class Parallelized
extends Parameterized {
    public Parallelized(Class klass) throws Throwable {
        super(klass);
        this.setScheduler(new NonBlockingAsynchronousRunner());
    }

    private static class ThreadPoolScheduler
    implements RunnerScheduler {
        private ExecutorService executor;

        public ThreadPoolScheduler() {
            String threads = System.getProperty("junit.parallel.threads", "16");
            int numThreads = Integer.parseInt(threads);
            this.executor = Executors.newFixedThreadPool(numThreads);
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }
    }

    private static class NonBlockingAsynchronousRunner
    implements RunnerScheduler {
        private final List<Future<Object>> futures = Collections.synchronizedList(new ArrayList());
        private final ExecutorService fService;

        public NonBlockingAsynchronousRunner() {
            String threads = System.getProperty("junit.parallel.threads", "16");
            int numThreads = Integer.parseInt(threads);
            this.fService = Executors.newFixedThreadPool(numThreads);
        }

        public void schedule(final Runnable childStatement) {
            Callable<Object> objectCallable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    childStatement.run();
                    return null;
                }
            };
            this.futures.add(this.fService.submit(objectCallable));
        }

        public void finished() {
            this.waitForCompletion();
        }

        public void waitForCompletion() {
            for (Future<Object> each : this.futures) {
                try {
                    each.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

