/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.junit;

import com.saucelabs.common.SauceOnDemandAuthentication;
import com.saucelabs.common.SauceOnDemandSessionIdProvider;
import com.saucelabs.common.Utils;
import com.saucelabs.saucerest.SauceREST;
import java.util.HashMap;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class SauceOnDemandTestWatcher
extends TestWatcher {
    private final SauceOnDemandSessionIdProvider sessionIdProvider;
    private final SauceREST sauceREST;
    private boolean verboseMode = true;

    public SauceOnDemandTestWatcher(SauceOnDemandSessionIdProvider sessionIdProvider) {
        this(sessionIdProvider, new SauceOnDemandAuthentication());
    }

    public SauceOnDemandTestWatcher(SauceOnDemandSessionIdProvider sessionIdProvider, boolean verboseMode) {
        this(sessionIdProvider, new SauceOnDemandAuthentication(), verboseMode);
    }

    public SauceOnDemandTestWatcher(SauceOnDemandSessionIdProvider sessionIdProvider, SauceOnDemandAuthentication authentication) {
        this(sessionIdProvider, authentication.getUsername(), authentication.getAccessKey(), true);
    }

    public SauceOnDemandTestWatcher(SauceOnDemandSessionIdProvider sessionIdProvider, SauceOnDemandAuthentication authentication, boolean verboseMode) {
        this(sessionIdProvider, authentication.getUsername(), authentication.getAccessKey(), verboseMode);
    }

    public SauceOnDemandTestWatcher(SauceOnDemandSessionIdProvider sessionIdProvider, String username, String accessKey, boolean verboseMode) {
        this.sessionIdProvider = sessionIdProvider;
        this.sauceREST = new SauceREST(username, accessKey);
        this.verboseMode = verboseMode;
    }

    protected void succeeded(Description description) {
        if (this.sessionIdProvider.getSessionId() != null) {
            this.printSessionId(description);
            HashMap<String, Boolean> updates = new HashMap<String, Boolean>();
            updates.put("passed", true);
            Utils.addBuildNumberToUpdate(updates);
            this.sauceREST.updateJobInfo(this.sessionIdProvider.getSessionId(), updates);
        }
    }

    private void printSessionId(Description description) {
        if (this.verboseMode) {
            String message = String.format("SauceOnDemandSessionID=%1$s job-name=%2$s.%3$s", this.sessionIdProvider.getSessionId(), description.getClassName(), description.getMethodName());
            System.out.println(message);
        }
    }

    protected void failed(Throwable e, Description description) {
        if (this.sessionIdProvider != null && this.sessionIdProvider.getSessionId() != null) {
            this.printSessionId(description);
            HashMap<String, Boolean> updates = new HashMap<String, Boolean>();
            updates.put("passed", false);
            Utils.addBuildNumberToUpdate(updates);
            this.sauceREST.updateJobInfo(this.sessionIdProvider.getSessionId(), updates);
            if (this.verboseMode) {
                String authLink = this.sauceREST.getPublicJobLink(this.sessionIdProvider.getSessionId());
                System.out.println("Job link: " + authLink);
            }
        }
    }
}

