//[okhttp](../../../index.md)/[okhttp3](../index.md)/[EventListener](index.md)

# EventListener

[jvm]\
abstract class [EventListener](index.md)

Listener for metrics events. Extend this class to monitor the quantity, size, and duration of your application's HTTP calls.

All start/connect/acquire events will eventually receive a matching end/release event, either successful (non-null parameters), or failed (non-null throwable). The first common parameters of each event pair are used to link the event in case of concurrent or repeated events e.g. `dnsStart(call, domainName)` → `dnsEnd(call, domainName, inetAddressList)`.

Events are typically nested with this structure:

- 
   call ([callStart](call-start.md), [callEnd](call-end.md), [callFailed](call-failed.md))
- - 
      proxy selection ([proxySelectStart](proxy-select-start.md), [proxySelectEnd](proxy-select-end.md))
   - 
      dns ([dnsStart](dns-start.md), [dnsEnd](dns-end.md))
   - 
      connect ([connectStart](connect-start.md), [connectEnd](connect-end.md), [connectFailed](connect-failed.md))
   - - 
         secure connect ([secureConnectStart](secure-connect-start.md), [secureConnectEnd](secure-connect-end.md))
   - 
      connection held ([connectionAcquired](connection-acquired.md), [connectionReleased](connection-released.md))
   - - 
         request ([requestFailed](request-failed.md))
      - - 
            headers ([requestHeadersStart](request-headers-start.md), [requestHeadersEnd](request-headers-end.md))
         - 
            body ([requestBodyStart](request-body-start.md), [requestBodyEnd](request-body-end.md))
      - 
         response ([responseFailed](response-failed.md))
      - - 
            headers ([responseHeadersStart](response-headers-start.md), [responseHeadersEnd](response-headers-end.md))
         - 
            body ([responseBodyStart](response-body-start.md), [responseBodyEnd](response-body-end.md))

This nesting is typical but not strict. For example, when calls use &quot;Expect: continue&quot; the request body start and end events occur within the response header events. Similarly, [duplex calls](../-request-body/is-duplex.md) interleave the request and response bodies.

Since connections may be reused, the proxy selection, DNS, and connect events may not be present for a call. In future releases of OkHttp these events may also occur concurrently to permit multiple routes to be attempted simultaneously.

Events and sequences of events may be repeated for retries and follow-ups.

All event methods must execute fast, without external locking, cannot throw exceptions, attempt to mutate the event parameters, or be re-entrant back into the client. Any IO - writing to files or network should be done asynchronously.

## Constructors

| | |
|---|---|
| [EventListener](-event-listener.md) | [jvm]<br>fun [EventListener](-event-listener.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |
| [Factory](-factory/index.md) | [jvm]<br>fun interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [cacheConditionalHit](cache-conditional-hit.md) | [jvm]<br>open fun [cacheConditionalHit](cache-conditional-hit.md)(call: [Call](../-call/index.md), cachedResponse: [Response](../-response/index.md))<br>Invoked when a response will be served from the cache or network based on validating the cached Response freshness. Will be followed by cacheHit or cacheMiss after the network Response is available. |
| [cacheHit](cache-hit.md) | [jvm]<br>open fun [cacheHit](cache-hit.md)(call: [Call](../-call/index.md), response: [Response](../-response/index.md))<br>Invoked when a result is served from the cache. The Response provided is the top level Response and normal event sequences will not be received. |
| [cacheMiss](cache-miss.md) | [jvm]<br>open fun [cacheMiss](cache-miss.md)(call: [Call](../-call/index.md))<br>Invoked when a response will be served from the network. The Response will be available from normal event sequences. |
| [callEnd](call-end.md) | [jvm]<br>open fun [callEnd](call-end.md)(call: [Call](../-call/index.md))<br>Invoked immediately after a call has completely ended.  This includes delayed consumption of response body by the caller. |
| [callFailed](call-failed.md) | [jvm]<br>open fun [callFailed](call-failed.md)(call: [Call](../-call/index.md), ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html))<br>Invoked when a call fails permanently. |
| [callStart](call-start.md) | [jvm]<br>open fun [callStart](call-start.md)(call: [Call](../-call/index.md))<br>Invoked as soon as a call is enqueued or executed by a client. In case of thread or stream limits, this call may be executed well before processing the request is able to begin. |
| [canceled](canceled.md) | [jvm]<br>open fun [canceled](canceled.md)(call: [Call](../-call/index.md))<br>Invoked when a call is canceled. |
| [connectEnd](connect-end.md) | [jvm]<br>open fun [connectEnd](connect-end.md)(call: [Call](../-call/index.md), inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), protocol: Protocol?)<br>Invoked immediately after a socket connection was attempted. |
| [connectFailed](connect-failed.md) | [jvm]<br>open fun [connectFailed](connect-failed.md)(call: [Call](../-call/index.md), inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), protocol: Protocol?, ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html))<br>Invoked when a connection attempt fails. This failure is not terminal if further routes are available and failure recovery is enabled. |
| [connectionAcquired](connection-acquired.md) | [jvm]<br>open fun [connectionAcquired](connection-acquired.md)(call: [Call](../-call/index.md), connection: [Connection](../-connection/index.md))<br>Invoked after a connection has been acquired for the `call`. |
| [connectionReleased](connection-released.md) | [jvm]<br>open fun [connectionReleased](connection-released.md)(call: [Call](../-call/index.md), connection: [Connection](../-connection/index.md))<br>Invoked after a connection has been released for the `call`. |
| [connectStart](connect-start.md) | [jvm]<br>open fun [connectStart](connect-start.md)(call: [Call](../-call/index.md), inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html))<br>Invoked just prior to initiating a socket connection. |
| [dnsEnd](dns-end.md) | [jvm]<br>open fun [dnsEnd](dns-end.md)(call: [Call](../-call/index.md), domainName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), inetAddressList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[InetAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html)&gt;)<br>Invoked immediately after a DNS lookup. |
| [dnsStart](dns-start.md) | [jvm]<br>open fun [dnsStart](dns-start.md)(call: [Call](../-call/index.md), domainName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>Invoked just prior to a DNS lookup. See [Dns.lookup](../-dns/lookup.md). |
| [proxySelectEnd](proxy-select-end.md) | [jvm]<br>open fun [proxySelectEnd](proxy-select-end.md)(call: [Call](../-call/index.md), url: [HttpUrl](../-http-url/index.md), proxies: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)&gt;)<br>Invoked after proxy selection. |
| [proxySelectStart](proxy-select-start.md) | [jvm]<br>open fun [proxySelectStart](proxy-select-start.md)(call: [Call](../-call/index.md), url: [HttpUrl](../-http-url/index.md))<br>Invoked prior to a proxy selection. |
| [requestBodyEnd](request-body-end.md) | [jvm]<br>open fun [requestBodyEnd](request-body-end.md)(call: [Call](../-call/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Invoked immediately after sending a request body. |
| [requestBodyStart](request-body-start.md) | [jvm]<br>open fun [requestBodyStart](request-body-start.md)(call: [Call](../-call/index.md))<br>Invoked just prior to sending a request body.  Will only be invoked for request allowing and having a request body to send. |
| [requestFailed](request-failed.md) | [jvm]<br>open fun [requestFailed](request-failed.md)(call: [Call](../-call/index.md), ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html))<br>Invoked when a request fails to be written. |
| [requestHeadersEnd](request-headers-end.md) | [jvm]<br>open fun [requestHeadersEnd](request-headers-end.md)(call: [Call](../-call/index.md), request: [Request](../-request/index.md))<br>Invoked immediately after sending request headers. |
| [requestHeadersStart](request-headers-start.md) | [jvm]<br>open fun [requestHeadersStart](request-headers-start.md)(call: [Call](../-call/index.md))<br>Invoked just prior to sending request headers. |
| [responseBodyEnd](response-body-end.md) | [jvm]<br>open fun [responseBodyEnd](response-body-end.md)(call: [Call](../-call/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Invoked immediately after receiving a response body and completing reading it. |
| [responseBodyStart](response-body-start.md) | [jvm]<br>open fun [responseBodyStart](response-body-start.md)(call: [Call](../-call/index.md))<br>Invoked when data from the response body is first available to the application. |
| [responseFailed](response-failed.md) | [jvm]<br>open fun [responseFailed](response-failed.md)(call: [Call](../-call/index.md), ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html))<br>Invoked when a response fails to be read. |
| [responseHeadersEnd](response-headers-end.md) | [jvm]<br>open fun [responseHeadersEnd](response-headers-end.md)(call: [Call](../-call/index.md), response: [Response](../-response/index.md))<br>Invoked immediately after receiving response headers. |
| [responseHeadersStart](response-headers-start.md) | [jvm]<br>open fun [responseHeadersStart](response-headers-start.md)(call: [Call](../-call/index.md))<br>Invoked when response headers are first returned from the server. |
| [satisfactionFailure](satisfaction-failure.md) | [jvm]<br>open fun [satisfactionFailure](satisfaction-failure.md)(call: [Call](../-call/index.md), response: [Response](../-response/index.md))<br>Invoked when a call fails due to cache rules. For example, we're forbidden from using the network and the cache is insufficient |
| [secureConnectEnd](secure-connect-end.md) | [jvm]<br>open fun [secureConnectEnd](secure-connect-end.md)(call: [Call](../-call/index.md), handshake: [Handshake](../-handshake/index.md)?)<br>Invoked immediately after a TLS connection was attempted. |
| [secureConnectStart](secure-connect-start.md) | [jvm]<br>open fun [secureConnectStart](secure-connect-start.md)(call: [Call](../-call/index.md))<br>Invoked just prior to initiating a TLS connection. |
