//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Headers](index.md)/[equals](equals.md)

# equals

[common]\
expect open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Returns true if `other` is a `Headers` object with the same headers, with the same casing, in the same order. Note that two headers instances may be *semantically* equal but not equal according to this method. In particular, none of the following sets of headers are equal according to this method:

1. 
   Original

```kotlin
Content-Type: text/html
Content-Length: 50
```

1. 
   Different order

```kotlin
Content-Length: 50
Content-Type: text/html
```

1. 
   Different case

```kotlin
content-type: text/html
content-length: 50
```

1. 
   Different values

```kotlin
Content-Type: text/html
Content-Length: 050
```

Applications that require semantically equal headers should convert them into a canonical form before comparing them for equality.

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)
