//[okhttp](../../../index.md)/[okhttp3](../index.md)/[ResponseBody](index.md)/[string](string.md)

# string

[common]\
expect fun [string](string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

Returns the response as a string.

On Non JVM Platforms, this only supports the UTF-8 encoding, all other encodings will be treated as unknown.

On JVM Platforms:

If the response starts with a [Byte Order Mark (BOM)](https://en.wikipedia.org/wiki/Byte_order_mark), it is consumed and used to determine the charset of the response bytes.

Otherwise if the response has a `Content-Type` header that specifies a charset, that is used to determine the charset of the response bytes.

Otherwise the response bytes are decoded as UTF-8.

This method loads entire response body into memory. If the response body is very large this may trigger an OutOfMemoryError. Prefer to stream the response body if this is a possibility for your response.

[jvm, nonJvm]\
[jvm, nonJvm]\
actual fun [string](string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)
