/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindGroupsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsQueryFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestFindGroupsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcFindGroups {
    private WsQueryFilter queryFilter;
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private Set<Long> groupIdIndexes = new LinkedHashSet<Long>();

    public GcFindGroups assignQueryFilter(WsQueryFilter theQueryFilter) {
        this.queryFilter = theQueryFilter;
        return this;
    }

    public GcFindGroups assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcFindGroups addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcFindGroups addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcFindGroups assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (this.queryFilter == null && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupIdIndexes) == 0) {
            throw new RuntimeException("Need to pass in a query filter, or groupNames or groupUuids or groupIdIndexes: " + this);
        }
    }

    public GcFindGroups assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public WsFindGroupsResults execute() {
        this.validate();
        WsFindGroupsResults wsFindGroupsResults = null;
        try {
            WsRestFindGroupsRequest findGroups = new WsRestFindGroupsRequest();
            findGroups.setActAsSubjectLookup(this.actAsSubject);
            if (this.includeGroupDetail != null) {
                findGroups.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            findGroups.setWsQueryFilter(this.queryFilter);
            if (this.params.size() > 0) {
                findGroups.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            for (Long groupIdIndex : this.groupIdIndexes) {
                groupLookups.add(new WsGroupLookup(null, null, groupIdIndex.toString()));
            }
            findGroups.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsFindGroupsResults = (WsFindGroupsResults)grouperClientWs.executeService("groups", findGroups, "findGroups", this.clientVersion, true);
            String resultMessage = wsFindGroupsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsFindGroupsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsFindGroupsResults;
    }

    public GcFindGroups addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcFindGroups addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcFindGroups addGroupIdIndex(Long theGroupIdIndex) {
        this.groupIdIndexes.add(theGroupIdIndex);
        return this;
    }
}

