/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.WsRestClassLookup;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.XStream;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.DomDriver;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.util.List;
import java.util.Map;

public class GrouperClientXstreamUtils {
    static Log log = GrouperClientUtils.retrieveLog(GrouperClientXstreamUtils.class);

    public static XStream retrieveXstream() {
        return GrouperClientXstreamUtils.retrieveXstream(WsRestClassLookup.getAliasClassMap());
    }

    public static XStream retrieveXstream(Map<String, Class<?>> aliasClassMap) {
        boolean ignoreExtraneousFields = GrouperClientConfig.retrieveConfig().propertyValueBooleanRequired("grouperClient.webService.ignoreExtraneousXmlFields");
        XStream xStream = null;
        xStream = ignoreExtraneousFields ? new XStream(new DomDriver()){

            @Override
            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper(next){

                    @Override
                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        boolean definedInNotObject;
                        boolean bl = definedInNotObject = definedIn != Object.class;
                        if (definedInNotObject) {
                            return super.shouldSerializeMember(definedIn, fieldName);
                        }
                        log.info("Cant find field: " + fieldName);
                        return false;
                    }
                };
            }
        } : new XStream(new DomDriver());
        xStream.setMode(1001);
        for (String key : GrouperClientUtils.nonNull(aliasClassMap).keySet()) {
            xStream.alias(key, aliasClassMap.get(key));
        }
        xStream.autodetectAnnotations(true);
        String fieldsToOmit = GrouperClientConfig.retrieveConfig().propertyValueString("grouper.webService.omitXmlProperties");
        if (!GrouperClientUtils.isBlank(fieldsToOmit)) {
            List<String> fieldsToOmitList = GrouperClientUtils.splitTrimToList(fieldsToOmit, ",");
            for (String fieldToOmit : fieldsToOmitList) {
                if (GrouperClientUtils.isBlank(fieldToOmit)) continue;
                try {
                    int dotIndex = fieldToOmit.lastIndexOf(46);
                    String className = fieldToOmit.substring(0, dotIndex);
                    String propertyName = fieldToOmit.substring(dotIndex + 1, fieldToOmit.length());
                    Class theClass = GrouperClientUtils.forName(className);
                    xStream.omitField(theClass, propertyName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem with grouper.webService.omitXmlProperties: " + fieldsToOmit + ", " + e.getMessage(), e);
                }
            }
        }
        return xStream;
    }
}

